/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyRuleFluent<A extends PolicyRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> apiGroups = new ArrayList<String>();
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> resourceNames = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PolicyRuleFluent() {
    }

    public PolicyRuleFluent(PolicyRule instance) {
        PolicyRule policyRule = instance = instance != null ? instance : new PolicyRule();
        if (instance != null) {
            this.withApiGroups(instance.getApiGroups());
            this.withNonResourceURLs(instance.getNonResourceURLs());
            this.withResourceNames(instance.getResourceNames());
            this.withResources(instance.getResources());
            this.withVerbs(instance.getVerbs());
            this.withApiGroups(instance.getApiGroups());
            this.withNonResourceURLs(instance.getNonResourceURLs());
            this.withResourceNames(instance.getResourceNames());
            this.withResources(instance.getResources());
            this.withVerbs(instance.getVerbs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiGroups(String ... items) {
        if (this.apiGroups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiGroups(List<String> apiGroups) {
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)((Object)this);
    }

    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
            this._visitables.remove((Object)"apiGroups");
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    public A addToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)((Object)this);
    }

    public A setToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)((Object)this);
    }

    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nonResourceURLs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nonResourceURLs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public String getNonResourceURL(int index) {
        return this.nonResourceURLs.get(index);
    }

    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)((Object)this);
    }

    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
            this._visitables.remove((Object)"nonResourceURLs");
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    public A addToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToResourceNames(String ... items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResourceNames(Collection<String> items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResourceNames(String ... items) {
        if (this.resourceNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resourceNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourceNames(Collection<String> items) {
        if (this.resourceNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resourceNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public String getResourceName(int index) {
        return this.resourceNames.get(index);
    }

    public String getFirstResourceName() {
        return this.resourceNames.get(0);
    }

    public String getLastResourceName() {
        return this.resourceNames.get(this.resourceNames.size() - 1);
    }

    public String getMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceNames(List<String> resourceNames) {
        if (resourceNames != null) {
            this.resourceNames = new ArrayList<String>();
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        } else {
            this.resourceNames = null;
        }
        return (A)((Object)this);
    }

    public A withResourceNames(String ... resourceNames) {
        if (this.resourceNames != null) {
            this.resourceNames.clear();
            this._visitables.remove((Object)"resourceNames");
        }
        if (resourceNames != null) {
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourceNames() {
        return this.resourceNames != null && !this.resourceNames.isEmpty();
    }

    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)((Object)this);
    }

    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)((Object)this);
    }

    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(String ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<String> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)((Object)this);
    }

    public A setToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)((Object)this);
    }

    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVerbs(String ... items) {
        if (this.verbs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVerbs(Collection<String> items) {
        if (this.verbs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVerbs() {
        return this.verbs;
    }

    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)((Object)this);
    }

    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
            this._visitables.remove((Object)"verbs");
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyRuleFluent that = (PolicyRuleFluent)((Object)o);
        if (!Objects.equals(this.apiGroups, that.apiGroups)) {
            return false;
        }
        if (!Objects.equals(this.nonResourceURLs, that.nonResourceURLs)) {
            return false;
        }
        if (!Objects.equals(this.resourceNames, that.resourceNames)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.verbs, that.verbs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.nonResourceURLs, this.resourceNames, this.resources, this.verbs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiGroups != null && !this.apiGroups.isEmpty()) {
            sb.append("apiGroups:");
            sb.append(this.apiGroups + ",");
        }
        if (this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty()) {
            sb.append("nonResourceURLs:");
            sb.append(this.nonResourceURLs + ",");
        }
        if (this.resourceNames != null && !this.resourceNames.isEmpty()) {
            sb.append("resourceNames:");
            sb.append(this.resourceNames + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.verbs != null && !this.verbs.isEmpty()) {
            sb.append("verbs:");
            sb.append(this.verbs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

