package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StructuredResourceHandleFluent<A extends StructuredResourceHandleFluent<A>> extends BaseFluent<A>{
  public StructuredResourceHandleFluent() {
  }
  
  public StructuredResourceHandleFluent(StructuredResourceHandle instance) {
    this.copyInstance(instance);
  }
  private String nodeName;
  private ArrayList<DriverAllocationResultBuilder> results = new ArrayList<DriverAllocationResultBuilder>();
  private Map<String,Object> vendorClaimParameters;
  private Map<String,Object> vendorClassParameters;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StructuredResourceHandle instance) {
    instance = (instance != null ? instance : new StructuredResourceHandle());
    if (instance != null) {
          this.withNodeName(instance.getNodeName());
          this.withResults(instance.getResults());
          this.withVendorClaimParameters(instance.getVendorClaimParameters());
          this.withVendorClassParameters(instance.getVendorClassParameters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getNodeName() {
    return this.nodeName;
  }
  
  public A withNodeName(String nodeName) {
    this.nodeName = nodeName;
    return (A) this;
  }
  
  public boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  public A addToResults(int index,DriverAllocationResult item) {
    if (this.results == null) {this.results = new ArrayList<DriverAllocationResultBuilder>();}
    DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
    if (index < 0 || index >= results.size()) { _visitables.get("results").add(builder); results.add(builder); } else { _visitables.get("results").add(index, builder); results.add(index, builder);}
    return (A)this;
  }
  
  public A setToResults(int index,DriverAllocationResult item) {
    if (this.results == null) {this.results = new ArrayList<DriverAllocationResultBuilder>();}
    DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);
    if (index < 0 || index >= results.size()) { _visitables.get("results").add(builder); results.add(builder); } else { _visitables.get("results").set(index, builder); results.set(index, builder);}
    return (A)this;
  }
  
  public A addToResults(io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverAllocationResult... items) {
    if (this.results == null) {this.results = new ArrayList<DriverAllocationResultBuilder>();}
    for (DriverAllocationResult item : items) {DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  
  public A addAllToResults(Collection<DriverAllocationResult> items) {
    if (this.results == null) {this.results = new ArrayList<DriverAllocationResultBuilder>();}
    for (DriverAllocationResult item : items) {DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  
  public A removeFromResults(io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverAllocationResult... items) {
    if (this.results == null) return (A)this;
    for (DriverAllocationResult item : items) {DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);_visitables.get("results").remove(builder); this.results.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResults(Collection<DriverAllocationResult> items) {
    if (this.results == null) return (A)this;
    for (DriverAllocationResult item : items) {DriverAllocationResultBuilder builder = new DriverAllocationResultBuilder(item);_visitables.get("results").remove(builder); this.results.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResults(Predicate<DriverAllocationResultBuilder> predicate) {
    if (results == null) return (A) this;
    final Iterator<DriverAllocationResultBuilder> each = results.iterator();
    final List visitables = _visitables.get("results");
    while (each.hasNext()) {
      DriverAllocationResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DriverAllocationResult> buildResults() {
    return this.results != null ? build(results) : null;
  }
  
  public DriverAllocationResult buildResult(int index) {
    return this.results.get(index).build();
  }
  
  public DriverAllocationResult buildFirstResult() {
    return this.results.get(0).build();
  }
  
  public DriverAllocationResult buildLastResult() {
    return this.results.get(results.size() - 1).build();
  }
  
  public DriverAllocationResult buildMatchingResult(Predicate<DriverAllocationResultBuilder> predicate) {
      for (DriverAllocationResultBuilder item : results) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResult(Predicate<DriverAllocationResultBuilder> predicate) {
      for (DriverAllocationResultBuilder item : results) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResults(List<DriverAllocationResult> results) {
    if (this.results != null) {
      this._visitables.get("results").clear();
    }
    if (results != null) {
        this.results = new ArrayList();
        for (DriverAllocationResult item : results) {
          this.addToResults(item);
        }
    } else {
      this.results = null;
    }
    return (A) this;
  }
  
  public A withResults(io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverAllocationResult... results) {
    if (this.results != null) {
        this.results.clear();
        _visitables.remove("results");
    }
    if (results != null) {
      for (DriverAllocationResult item : results) {
        this.addToResults(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResults() {
    return this.results != null && !this.results.isEmpty();
  }
  
  public ResultsNested<A> addNewResult() {
    return new ResultsNested(-1, null);
  }
  
  public ResultsNested<A> addNewResultLike(DriverAllocationResult item) {
    return new ResultsNested(-1, item);
  }
  
  public ResultsNested<A> setNewResultLike(int index,DriverAllocationResult item) {
    return new ResultsNested(index, item);
  }
  
  public ResultsNested<A> editResult(int index) {
    if (results.size() <= index) throw new RuntimeException("Can't edit results. Index exceeds size.");
    return setNewResultLike(index, buildResult(index));
  }
  
  public ResultsNested<A> editFirstResult() {
    if (results.size() == 0) throw new RuntimeException("Can't edit first results. The list is empty.");
    return setNewResultLike(0, buildResult(0));
  }
  
  public ResultsNested<A> editLastResult() {
    int index = results.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last results. The list is empty.");
    return setNewResultLike(index, buildResult(index));
  }
  
  public ResultsNested<A> editMatchingResult(Predicate<DriverAllocationResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<results.size();i++) { 
    if (predicate.test(results.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching results. No match found.");
    return setNewResultLike(index, buildResult(index));
  }
  
  public A addToVendorClaimParameters(String key,Object value) {
    if(this.vendorClaimParameters == null && key != null && value != null) { this.vendorClaimParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.vendorClaimParameters.put(key, value);} return (A)this;
  }
  
  public A addToVendorClaimParameters(Map<String,Object> map) {
    if(this.vendorClaimParameters == null && map != null) { this.vendorClaimParameters = new LinkedHashMap(); }
    if(map != null) { this.vendorClaimParameters.putAll(map);} return (A)this;
  }
  
  public A removeFromVendorClaimParameters(String key) {
    if(this.vendorClaimParameters == null) { return (A) this; }
    if(key != null && this.vendorClaimParameters != null) {this.vendorClaimParameters.remove(key);} return (A)this;
  }
  
  public A removeFromVendorClaimParameters(Map<String,Object> map) {
    if(this.vendorClaimParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.vendorClaimParameters != null){this.vendorClaimParameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getVendorClaimParameters() {
    return this.vendorClaimParameters;
  }
  
  public <K,V>A withVendorClaimParameters(Map<String,Object> vendorClaimParameters) {
    if (vendorClaimParameters == null) {
      this.vendorClaimParameters = null;
    } else {
      this.vendorClaimParameters = new LinkedHashMap(vendorClaimParameters);
    }
    return (A) this;
  }
  
  public boolean hasVendorClaimParameters() {
    return this.vendorClaimParameters != null;
  }
  
  public A addToVendorClassParameters(String key,Object value) {
    if(this.vendorClassParameters == null && key != null && value != null) { this.vendorClassParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.vendorClassParameters.put(key, value);} return (A)this;
  }
  
  public A addToVendorClassParameters(Map<String,Object> map) {
    if(this.vendorClassParameters == null && map != null) { this.vendorClassParameters = new LinkedHashMap(); }
    if(map != null) { this.vendorClassParameters.putAll(map);} return (A)this;
  }
  
  public A removeFromVendorClassParameters(String key) {
    if(this.vendorClassParameters == null) { return (A) this; }
    if(key != null && this.vendorClassParameters != null) {this.vendorClassParameters.remove(key);} return (A)this;
  }
  
  public A removeFromVendorClassParameters(Map<String,Object> map) {
    if(this.vendorClassParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.vendorClassParameters != null){this.vendorClassParameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getVendorClassParameters() {
    return this.vendorClassParameters;
  }
  
  public <K,V>A withVendorClassParameters(Map<String,Object> vendorClassParameters) {
    if (vendorClassParameters == null) {
      this.vendorClassParameters = null;
    } else {
      this.vendorClassParameters = new LinkedHashMap(vendorClassParameters);
    }
    return (A) this;
  }
  
  public boolean hasVendorClassParameters() {
    return this.vendorClassParameters != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StructuredResourceHandleFluent that = (StructuredResourceHandleFluent) o;
    if (!java.util.Objects.equals(nodeName, that.nodeName)) return false;
    if (!java.util.Objects.equals(results, that.results)) return false;
    if (!java.util.Objects.equals(vendorClaimParameters, that.vendorClaimParameters)) return false;
    if (!java.util.Objects.equals(vendorClassParameters, that.vendorClassParameters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nodeName,  results,  vendorClaimParameters,  vendorClassParameters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (results != null && !results.isEmpty()) { sb.append("results:"); sb.append(results + ","); }
    if (vendorClaimParameters != null && !vendorClaimParameters.isEmpty()) { sb.append("vendorClaimParameters:"); sb.append(vendorClaimParameters + ","); }
    if (vendorClassParameters != null && !vendorClassParameters.isEmpty()) { sb.append("vendorClassParameters:"); sb.append(vendorClassParameters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResultsNested<N> extends DriverAllocationResultFluent<ResultsNested<N>> implements Nested<N>{
    ResultsNested(int index,DriverAllocationResult item) {
      this.index = index;
      this.builder = new DriverAllocationResultBuilder(this, item);
    }
    DriverAllocationResultBuilder builder;
    int index;
    
    public N and() {
      return (N) StructuredResourceHandleFluent.this.setToResults(index,builder.build());
    }
    
    public N endResult() {
      return and();
    }
    
  
  }

}