package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingBuilder extends PodSchedulingFluentImpl<PodSchedulingBuilder> implements VisitableBuilder<PodScheduling,PodSchedulingBuilder>{
  public PodSchedulingBuilder() {
    this(false);
  }
  public PodSchedulingBuilder(Boolean validationEnabled) {
    this(new PodScheduling(), validationEnabled);
  }
  public PodSchedulingBuilder(PodSchedulingFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingBuilder(PodSchedulingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodScheduling(), validationEnabled);
  }
  public PodSchedulingBuilder(PodSchedulingFluent<?> fluent,PodScheduling instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingBuilder(PodSchedulingFluent<?> fluent,PodScheduling instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingBuilder(PodScheduling instance) {
    this(instance,false);
  }
  public PodSchedulingBuilder(PodScheduling instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingFluent<?> fluent;
  Boolean validationEnabled;
  public PodScheduling build() {
    PodScheduling buildable = new PodScheduling(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}