package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimParametersReferenceBuilder extends ResourceClaimParametersReferenceFluentImpl<ResourceClaimParametersReferenceBuilder> implements VisitableBuilder<ResourceClaimParametersReference,ResourceClaimParametersReferenceBuilder>{
  public ResourceClaimParametersReferenceBuilder() {
    this(false);
  }
  public ResourceClaimParametersReferenceBuilder(Boolean validationEnabled) {
    this(new ResourceClaimParametersReference(), validationEnabled);
  }
  public ResourceClaimParametersReferenceBuilder(ResourceClaimParametersReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimParametersReferenceBuilder(ResourceClaimParametersReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimParametersReference(), validationEnabled);
  }
  public ResourceClaimParametersReferenceBuilder(ResourceClaimParametersReferenceFluent<?> fluent,ResourceClaimParametersReference instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimParametersReferenceBuilder(ResourceClaimParametersReferenceFluent<?> fluent,ResourceClaimParametersReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimParametersReferenceBuilder(ResourceClaimParametersReference instance) {
    this(instance,false);
  }
  public ResourceClaimParametersReferenceBuilder(ResourceClaimParametersReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimParametersReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimParametersReference build() {
    ResourceClaimParametersReference buildable = new ResourceClaimParametersReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}