package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ResourceClassFluent<A extends ResourceClassFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getDriverName();
  public A withDriverName(String driverName);
  public Boolean hasDriverName();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ResourceClassFluent.MetadataNested<A> withNewMetadata();
  public ResourceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ResourceClassFluent.MetadataNested<A> editMetadata();
  public ResourceClassFluent.MetadataNested<A> editOrNewMetadata();
  public ResourceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildParametersRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceClassParametersReference getParametersRef();
  public ResourceClassParametersReference buildParametersRef();
  public A withParametersRef(ResourceClassParametersReference parametersRef);
  public Boolean hasParametersRef();
  public A withNewParametersRef(String apiGroup,String kind,String name,String namespace);
  public ResourceClassFluent.ParametersRefNested<A> withNewParametersRef();
  public ResourceClassFluent.ParametersRefNested<A> withNewParametersRefLike(ResourceClassParametersReference item);
  public ResourceClassFluent.ParametersRefNested<A> editParametersRef();
  public ResourceClassFluent.ParametersRefNested<A> editOrNewParametersRef();
  public ResourceClassFluent.ParametersRefNested<A> editOrNewParametersRefLike(ResourceClassParametersReference item);
  public NodeSelector getSuitableNodes();
  public A withSuitableNodes(NodeSelector suitableNodes);
  public Boolean hasSuitableNodes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ResourceClassFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface ParametersRefNested<N> extends Nested<N>,ResourceClassParametersReferenceFluent<ResourceClassFluent.ParametersRefNested<N>>{
    public N and();
    public N endParametersRef();
    
  }
  
}