package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AllocationResultBuilder extends AllocationResultFluent<AllocationResultBuilder> implements VisitableBuilder<AllocationResult,AllocationResultBuilder>{
  public AllocationResultBuilder() {
    this(false);
  }
  public AllocationResultBuilder(Boolean validationEnabled) {
    this(new AllocationResult(), validationEnabled);
  }
  public AllocationResultBuilder(AllocationResultFluent<?> fluent) {
    this(fluent, false);
  }
  public AllocationResultBuilder(AllocationResultFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AllocationResult(), validationEnabled);
  }
  public AllocationResultBuilder(AllocationResultFluent<?> fluent,AllocationResult instance) {
    this(fluent, instance, false);
  }
  public AllocationResultBuilder(AllocationResultFluent<?> fluent,AllocationResult instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AllocationResult());

    if (instance != null) {
      fluent.withAvailableOnNodes(instance.getAvailableOnNodes());
      fluent.withResourceHandles(instance.getResourceHandles());
      fluent.withShareable(instance.getShareable());
      fluent.withAvailableOnNodes(instance.getAvailableOnNodes());
      fluent.withResourceHandles(instance.getResourceHandles());
      fluent.withShareable(instance.getShareable());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AllocationResultBuilder(AllocationResult instance) {
    this(instance,false);
  }
  public AllocationResultBuilder(AllocationResult instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AllocationResult());

    if (instance != null) {
      this.withAvailableOnNodes(instance.getAvailableOnNodes());
      this.withResourceHandles(instance.getResourceHandles());
      this.withShareable(instance.getShareable());
      this.withAvailableOnNodes(instance.getAvailableOnNodes());
      this.withResourceHandles(instance.getResourceHandles());
      this.withShareable(instance.getShareable());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AllocationResultFluent<?> fluent;
  Boolean validationEnabled;
  public AllocationResult build() {
    AllocationResult buildable = new AllocationResult(fluent.getAvailableOnNodes(),fluent.buildResourceHandles(),fluent.getShareable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}