package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingContextSpecBuilder extends PodSchedulingContextSpecFluent<PodSchedulingContextSpecBuilder> implements VisitableBuilder<PodSchedulingContextSpec,PodSchedulingContextSpecBuilder>{
  public PodSchedulingContextSpecBuilder() {
    this(false);
  }
  public PodSchedulingContextSpecBuilder(Boolean validationEnabled) {
    this(new PodSchedulingContextSpec(), validationEnabled);
  }
  public PodSchedulingContextSpecBuilder(PodSchedulingContextSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingContextSpecBuilder(PodSchedulingContextSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingContextSpec(), validationEnabled);
  }
  public PodSchedulingContextSpecBuilder(PodSchedulingContextSpecFluent<?> fluent,PodSchedulingContextSpec instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingContextSpecBuilder(PodSchedulingContextSpecFluent<?> fluent,PodSchedulingContextSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSchedulingContextSpec());

    if (instance != null) {
      fluent.withPotentialNodes(instance.getPotentialNodes());
      fluent.withSelectedNode(instance.getSelectedNode());
      fluent.withPotentialNodes(instance.getPotentialNodes());
      fluent.withSelectedNode(instance.getSelectedNode());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingContextSpecBuilder(PodSchedulingContextSpec instance) {
    this(instance,false);
  }
  public PodSchedulingContextSpecBuilder(PodSchedulingContextSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSchedulingContextSpec());

    if (instance != null) {
      this.withPotentialNodes(instance.getPotentialNodes());
      this.withSelectedNode(instance.getSelectedNode());
      this.withPotentialNodes(instance.getPotentialNodes());
      this.withSelectedNode(instance.getSelectedNode());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingContextSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingContextSpec build() {
    PodSchedulingContextSpec buildable = new PodSchedulingContextSpec(fluent.getPotentialNodes(),fluent.getSelectedNode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}