package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingContextStatusBuilder extends PodSchedulingContextStatusFluent<PodSchedulingContextStatusBuilder> implements VisitableBuilder<PodSchedulingContextStatus,PodSchedulingContextStatusBuilder>{
  public PodSchedulingContextStatusBuilder() {
    this(false);
  }
  public PodSchedulingContextStatusBuilder(Boolean validationEnabled) {
    this(new PodSchedulingContextStatus(), validationEnabled);
  }
  public PodSchedulingContextStatusBuilder(PodSchedulingContextStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingContextStatusBuilder(PodSchedulingContextStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingContextStatus(), validationEnabled);
  }
  public PodSchedulingContextStatusBuilder(PodSchedulingContextStatusFluent<?> fluent,PodSchedulingContextStatus instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingContextStatusBuilder(PodSchedulingContextStatusFluent<?> fluent,PodSchedulingContextStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSchedulingContextStatus());

    if (instance != null) {
      fluent.withResourceClaims(instance.getResourceClaims());
      fluent.withResourceClaims(instance.getResourceClaims());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingContextStatusBuilder(PodSchedulingContextStatus instance) {
    this(instance,false);
  }
  public PodSchedulingContextStatusBuilder(PodSchedulingContextStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSchedulingContextStatus());

    if (instance != null) {
      this.withResourceClaims(instance.getResourceClaims());
      this.withResourceClaims(instance.getResourceClaims());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingContextStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingContextStatus build() {
    PodSchedulingContextStatus buildable = new PodSchedulingContextStatus(fluent.buildResourceClaims());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}