package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimSchedulingStatusBuilder extends ResourceClaimSchedulingStatusFluent<ResourceClaimSchedulingStatusBuilder> implements VisitableBuilder<ResourceClaimSchedulingStatus,ResourceClaimSchedulingStatusBuilder>{
  public ResourceClaimSchedulingStatusBuilder() {
    this(false);
  }
  public ResourceClaimSchedulingStatusBuilder(Boolean validationEnabled) {
    this(new ResourceClaimSchedulingStatus(), validationEnabled);
  }
  public ResourceClaimSchedulingStatusBuilder(ResourceClaimSchedulingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimSchedulingStatusBuilder(ResourceClaimSchedulingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimSchedulingStatus(), validationEnabled);
  }
  public ResourceClaimSchedulingStatusBuilder(ResourceClaimSchedulingStatusFluent<?> fluent,ResourceClaimSchedulingStatus instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimSchedulingStatusBuilder(ResourceClaimSchedulingStatusFluent<?> fluent,ResourceClaimSchedulingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceClaimSchedulingStatus());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withUnsuitableNodes(instance.getUnsuitableNodes());
      fluent.withName(instance.getName());
      fluent.withUnsuitableNodes(instance.getUnsuitableNodes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimSchedulingStatusBuilder(ResourceClaimSchedulingStatus instance) {
    this(instance,false);
  }
  public ResourceClaimSchedulingStatusBuilder(ResourceClaimSchedulingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceClaimSchedulingStatus());

    if (instance != null) {
      this.withName(instance.getName());
      this.withUnsuitableNodes(instance.getUnsuitableNodes());
      this.withName(instance.getName());
      this.withUnsuitableNodes(instance.getUnsuitableNodes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimSchedulingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimSchedulingStatus build() {
    ResourceClaimSchedulingStatus buildable = new ResourceClaimSchedulingStatus(fluent.getName(),fluent.getUnsuitableNodes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}