package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimStatusBuilder extends ResourceClaimStatusFluent<ResourceClaimStatusBuilder> implements VisitableBuilder<ResourceClaimStatus,ResourceClaimStatusBuilder>{
  public ResourceClaimStatusBuilder() {
    this(false);
  }
  public ResourceClaimStatusBuilder(Boolean validationEnabled) {
    this(new ResourceClaimStatus(), validationEnabled);
  }
  public ResourceClaimStatusBuilder(ResourceClaimStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimStatusBuilder(ResourceClaimStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimStatus(), validationEnabled);
  }
  public ResourceClaimStatusBuilder(ResourceClaimStatusFluent<?> fluent,ResourceClaimStatus instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimStatusBuilder(ResourceClaimStatusFluent<?> fluent,ResourceClaimStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceClaimStatus());

    if (instance != null) {
      fluent.withAllocation(instance.getAllocation());
      fluent.withDeallocationRequested(instance.getDeallocationRequested());
      fluent.withDriverName(instance.getDriverName());
      fluent.withReservedFor(instance.getReservedFor());
      fluent.withAllocation(instance.getAllocation());
      fluent.withDeallocationRequested(instance.getDeallocationRequested());
      fluent.withDriverName(instance.getDriverName());
      fluent.withReservedFor(instance.getReservedFor());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimStatusBuilder(ResourceClaimStatus instance) {
    this(instance,false);
  }
  public ResourceClaimStatusBuilder(ResourceClaimStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceClaimStatus());

    if (instance != null) {
      this.withAllocation(instance.getAllocation());
      this.withDeallocationRequested(instance.getDeallocationRequested());
      this.withDriverName(instance.getDriverName());
      this.withReservedFor(instance.getReservedFor());
      this.withAllocation(instance.getAllocation());
      this.withDeallocationRequested(instance.getDeallocationRequested());
      this.withDriverName(instance.getDriverName());
      this.withReservedFor(instance.getReservedFor());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimStatus build() {
    ResourceClaimStatus buildable = new ResourceClaimStatus(fluent.buildAllocation(),fluent.getDeallocationRequested(),fluent.getDriverName(),fluent.buildReservedFor());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}