package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingContextListBuilder extends PodSchedulingContextListFluent<PodSchedulingContextListBuilder> implements VisitableBuilder<PodSchedulingContextList,PodSchedulingContextListBuilder>{
  public PodSchedulingContextListBuilder() {
    this(false);
  }
  public PodSchedulingContextListBuilder(Boolean validationEnabled) {
    this(new PodSchedulingContextList(), validationEnabled);
  }
  public PodSchedulingContextListBuilder(PodSchedulingContextListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingContextListBuilder(PodSchedulingContextListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingContextList(), validationEnabled);
  }
  public PodSchedulingContextListBuilder(PodSchedulingContextListFluent<?> fluent,PodSchedulingContextList instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingContextListBuilder(PodSchedulingContextListFluent<?> fluent,PodSchedulingContextList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSchedulingContextList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingContextListBuilder(PodSchedulingContextList instance) {
    this(instance,false);
  }
  public PodSchedulingContextListBuilder(PodSchedulingContextList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSchedulingContextList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingContextListFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingContextList build() {
    PodSchedulingContextList buildable = new PodSchedulingContextList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}