package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimBuilder extends ResourceClaimFluent<ResourceClaimBuilder> implements VisitableBuilder<ResourceClaim,ResourceClaimBuilder>{
  public ResourceClaimBuilder() {
    this(false);
  }
  public ResourceClaimBuilder(Boolean validationEnabled) {
    this(new ResourceClaim(), validationEnabled);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaim(), validationEnabled);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,ResourceClaim instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,ResourceClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceClaim());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimBuilder(ResourceClaim instance) {
    this(instance,false);
  }
  public ResourceClaimBuilder(ResourceClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceClaim());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaim build() {
    ResourceClaim buildable = new ResourceClaim(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}