package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimConsumerReferenceBuilder extends ResourceClaimConsumerReferenceFluent<ResourceClaimConsumerReferenceBuilder> implements VisitableBuilder<ResourceClaimConsumerReference,ResourceClaimConsumerReferenceBuilder>{
  public ResourceClaimConsumerReferenceBuilder() {
    this(false);
  }
  public ResourceClaimConsumerReferenceBuilder(Boolean validationEnabled) {
    this(new ResourceClaimConsumerReference(), validationEnabled);
  }
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimConsumerReference(), validationEnabled);
  }
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReferenceFluent<?> fluent,ResourceClaimConsumerReference instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReferenceFluent<?> fluent,ResourceClaimConsumerReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceClaimConsumerReference());

    if (instance != null) {
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withName(instance.getName());
      fluent.withResource(instance.getResource());
      fluent.withUid(instance.getUid());
      fluent.withApiGroup(instance.getApiGroup());
      fluent.withName(instance.getName());
      fluent.withResource(instance.getResource());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReference instance) {
    this(instance,false);
  }
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceClaimConsumerReference());

    if (instance != null) {
      this.withApiGroup(instance.getApiGroup());
      this.withName(instance.getName());
      this.withResource(instance.getResource());
      this.withUid(instance.getUid());
      this.withApiGroup(instance.getApiGroup());
      this.withName(instance.getName());
      this.withResource(instance.getResource());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimConsumerReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimConsumerReference build() {
    ResourceClaimConsumerReference buildable = new ResourceClaimConsumerReference(fluent.getApiGroup(),fluent.getName(),fluent.getResource(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}