package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClassListBuilder extends ResourceClassListFluent<ResourceClassListBuilder> implements VisitableBuilder<ResourceClassList,ResourceClassListBuilder>{
  public ResourceClassListBuilder() {
    this(false);
  }
  public ResourceClassListBuilder(Boolean validationEnabled) {
    this(new ResourceClassList(), validationEnabled);
  }
  public ResourceClassListBuilder(ResourceClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClassListBuilder(ResourceClassListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClassList(), validationEnabled);
  }
  public ResourceClassListBuilder(ResourceClassListFluent<?> fluent,ResourceClassList instance) {
    this(fluent, instance, false);
  }
  public ResourceClassListBuilder(ResourceClassListFluent<?> fluent,ResourceClassList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceClassList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClassListBuilder(ResourceClassList instance) {
    this(instance,false);
  }
  public ResourceClassListBuilder(ResourceClassList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceClassList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClassListFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClassList build() {
    ResourceClassList buildable = new ResourceClassList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}