package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedResourcesInstanceFluent<A extends NamedResourcesInstanceFluent<A>> extends BaseFluent<A>{
  public NamedResourcesInstanceFluent() {
  }
  
  public NamedResourcesInstanceFluent(NamedResourcesInstance instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NamedResourcesAttributeBuilder> attributes = new ArrayList<NamedResourcesAttributeBuilder>();
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedResourcesInstance instance) {
    instance = (instance != null ? instance : new NamedResourcesInstance());
    if (instance != null) {
          this.withAttributes(instance.getAttributes());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAttributes(int index,NamedResourcesAttribute item) {
    if (this.attributes == null) {this.attributes = new ArrayList<NamedResourcesAttributeBuilder>();}
    NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
    if (index < 0 || index >= attributes.size()) {
        _visitables.get("attributes").add(builder);
        attributes.add(builder);
    } else {
        _visitables.get("attributes").add(builder);
        attributes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAttributes(int index,NamedResourcesAttribute item) {
    if (this.attributes == null) {this.attributes = new ArrayList<NamedResourcesAttributeBuilder>();}
    NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);
    if (index < 0 || index >= attributes.size()) {
        _visitables.get("attributes").add(builder);
        attributes.add(builder);
    } else {
        _visitables.get("attributes").add(builder);
        attributes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAttributes(io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesAttribute... items) {
    if (this.attributes == null) {this.attributes = new ArrayList<NamedResourcesAttributeBuilder>();}
    for (NamedResourcesAttribute item : items) {NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);_visitables.get("attributes").add(builder);this.attributes.add(builder);} return (A)this;
  }
  
  public A addAllToAttributes(Collection<NamedResourcesAttribute> items) {
    if (this.attributes == null) {this.attributes = new ArrayList<NamedResourcesAttributeBuilder>();}
    for (NamedResourcesAttribute item : items) {NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);_visitables.get("attributes").add(builder);this.attributes.add(builder);} return (A)this;
  }
  
  public A removeFromAttributes(io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesAttribute... items) {
    if (this.attributes == null) return (A)this;
    for (NamedResourcesAttribute item : items) {NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);_visitables.get("attributes").remove(builder); this.attributes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAttributes(Collection<NamedResourcesAttribute> items) {
    if (this.attributes == null) return (A)this;
    for (NamedResourcesAttribute item : items) {NamedResourcesAttributeBuilder builder = new NamedResourcesAttributeBuilder(item);_visitables.get("attributes").remove(builder); this.attributes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAttributes(Predicate<NamedResourcesAttributeBuilder> predicate) {
    if (attributes == null) return (A) this;
    final Iterator<NamedResourcesAttributeBuilder> each = attributes.iterator();
    final List visitables = _visitables.get("attributes");
    while (each.hasNext()) {
      NamedResourcesAttributeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedResourcesAttribute> buildAttributes() {
    return this.attributes != null ? build(attributes) : null;
  }
  
  public NamedResourcesAttribute buildAttribute(int index) {
    return this.attributes.get(index).build();
  }
  
  public NamedResourcesAttribute buildFirstAttribute() {
    return this.attributes.get(0).build();
  }
  
  public NamedResourcesAttribute buildLastAttribute() {
    return this.attributes.get(attributes.size() - 1).build();
  }
  
  public NamedResourcesAttribute buildMatchingAttribute(Predicate<NamedResourcesAttributeBuilder> predicate) {
      for (NamedResourcesAttributeBuilder item : attributes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAttribute(Predicate<NamedResourcesAttributeBuilder> predicate) {
      for (NamedResourcesAttributeBuilder item : attributes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAttributes(List<NamedResourcesAttribute> attributes) {
    if (this.attributes != null) {
      this._visitables.get("attributes").clear();
    }
    if (attributes != null) {
        this.attributes = new ArrayList();
        for (NamedResourcesAttribute item : attributes) {
          this.addToAttributes(item);
        }
    } else {
      this.attributes = null;
    }
    return (A) this;
  }
  
  public A withAttributes(io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesAttribute... attributes) {
    if (this.attributes != null) {
        this.attributes.clear();
        _visitables.remove("attributes");
    }
    if (attributes != null) {
      for (NamedResourcesAttribute item : attributes) {
        this.addToAttributes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAttributes() {
    return this.attributes != null && !this.attributes.isEmpty();
  }
  
  public AttributesNested<A> addNewAttribute() {
    return new AttributesNested(-1, null);
  }
  
  public AttributesNested<A> addNewAttributeLike(NamedResourcesAttribute item) {
    return new AttributesNested(-1, item);
  }
  
  public AttributesNested<A> setNewAttributeLike(int index,NamedResourcesAttribute item) {
    return new AttributesNested(index, item);
  }
  
  public AttributesNested<A> editAttribute(int index) {
    if (attributes.size() <= index) throw new RuntimeException("Can't edit attributes. Index exceeds size.");
    return setNewAttributeLike(index, buildAttribute(index));
  }
  
  public AttributesNested<A> editFirstAttribute() {
    if (attributes.size() == 0) throw new RuntimeException("Can't edit first attributes. The list is empty.");
    return setNewAttributeLike(0, buildAttribute(0));
  }
  
  public AttributesNested<A> editLastAttribute() {
    int index = attributes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last attributes. The list is empty.");
    return setNewAttributeLike(index, buildAttribute(index));
  }
  
  public AttributesNested<A> editMatchingAttribute(Predicate<NamedResourcesAttributeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<attributes.size();i++) { 
    if (predicate.test(attributes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching attributes. No match found.");
    return setNewAttributeLike(index, buildAttribute(index));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedResourcesInstanceFluent that = (NamedResourcesInstanceFluent) o;
    if (!java.util.Objects.equals(attributes, that.attributes)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attributes,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attributes != null && !attributes.isEmpty()) { sb.append("attributes:"); sb.append(attributes + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AttributesNested<N> extends NamedResourcesAttributeFluent<AttributesNested<N>> implements Nested<N>{
    AttributesNested(int index,NamedResourcesAttribute item) {
      this.index = index;
      this.builder = new NamedResourcesAttributeBuilder(this, item);
    }
    NamedResourcesAttributeBuilder builder;
    int index;
    
    public N and() {
      return (N) NamedResourcesInstanceFluent.this.setToAttributes(index,builder.build());
    }
    
    public N endAttribute() {
      return and();
    }
    
  
  }

}