package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeviceAllocationResultFluent<A extends DeviceAllocationResultFluent<A>> extends BaseFluent<A>{
  public DeviceAllocationResultFluent() {
  }
  
  public DeviceAllocationResultFluent(DeviceAllocationResult instance) {
    this.copyInstance(instance);
  }
  private ArrayList<DeviceAllocationConfigurationBuilder> config = new ArrayList<DeviceAllocationConfigurationBuilder>();
  private ArrayList<DeviceRequestAllocationResultBuilder> results = new ArrayList<DeviceRequestAllocationResultBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DeviceAllocationResult instance) {
    instance = (instance != null ? instance : new DeviceAllocationResult());
    if (instance != null) {
          this.withConfig(instance.getConfig());
          this.withResults(instance.getResults());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConfig(int index,DeviceAllocationConfiguration item) {
    if (this.config == null) {this.config = new ArrayList<DeviceAllocationConfigurationBuilder>();}
    DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
    if (index < 0 || index >= config.size()) {
        _visitables.get("config").add(builder);
        config.add(builder);
    } else {
        _visitables.get("config").add(builder);
        config.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConfig(int index,DeviceAllocationConfiguration item) {
    if (this.config == null) {this.config = new ArrayList<DeviceAllocationConfigurationBuilder>();}
    DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
    if (index < 0 || index >= config.size()) {
        _visitables.get("config").add(builder);
        config.add(builder);
    } else {
        _visitables.get("config").add(builder);
        config.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConfig(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceAllocationConfiguration... items) {
    if (this.config == null) {this.config = new ArrayList<DeviceAllocationConfigurationBuilder>();}
    for (DeviceAllocationConfiguration item : items) {DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);_visitables.get("config").add(builder);this.config.add(builder);} return (A)this;
  }
  
  public A addAllToConfig(Collection<DeviceAllocationConfiguration> items) {
    if (this.config == null) {this.config = new ArrayList<DeviceAllocationConfigurationBuilder>();}
    for (DeviceAllocationConfiguration item : items) {DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);_visitables.get("config").add(builder);this.config.add(builder);} return (A)this;
  }
  
  public A removeFromConfig(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceAllocationConfiguration... items) {
    if (this.config == null) return (A)this;
    for (DeviceAllocationConfiguration item : items) {DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);_visitables.get("config").remove(builder); this.config.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConfig(Collection<DeviceAllocationConfiguration> items) {
    if (this.config == null) return (A)this;
    for (DeviceAllocationConfiguration item : items) {DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);_visitables.get("config").remove(builder); this.config.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
    if (config == null) return (A) this;
    final Iterator<DeviceAllocationConfigurationBuilder> each = config.iterator();
    final List visitables = _visitables.get("config");
    while (each.hasNext()) {
      DeviceAllocationConfigurationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DeviceAllocationConfiguration> buildConfig() {
    return this.config != null ? build(config) : null;
  }
  
  public DeviceAllocationConfiguration buildConfig(int index) {
    return this.config.get(index).build();
  }
  
  public DeviceAllocationConfiguration buildFirstConfig() {
    return this.config.get(0).build();
  }
  
  public DeviceAllocationConfiguration buildLastConfig() {
    return this.config.get(config.size() - 1).build();
  }
  
  public DeviceAllocationConfiguration buildMatchingConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
      for (DeviceAllocationConfigurationBuilder item : config) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
      for (DeviceAllocationConfigurationBuilder item : config) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConfig(List<DeviceAllocationConfiguration> config) {
    if (this.config != null) {
      this._visitables.get("config").clear();
    }
    if (config != null) {
        this.config = new ArrayList();
        for (DeviceAllocationConfiguration item : config) {
          this.addToConfig(item);
        }
    } else {
      this.config = null;
    }
    return (A) this;
  }
  
  public A withConfig(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceAllocationConfiguration... config) {
    if (this.config != null) {
        this.config.clear();
        _visitables.remove("config");
    }
    if (config != null) {
      for (DeviceAllocationConfiguration item : config) {
        this.addToConfig(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null && !this.config.isEmpty();
  }
  
  public ConfigNested<A> addNewConfig() {
    return new ConfigNested(-1, null);
  }
  
  public ConfigNested<A> addNewConfigLike(DeviceAllocationConfiguration item) {
    return new ConfigNested(-1, item);
  }
  
  public ConfigNested<A> setNewConfigLike(int index,DeviceAllocationConfiguration item) {
    return new ConfigNested(index, item);
  }
  
  public ConfigNested<A> editConfig(int index) {
    if (config.size() <= index) throw new RuntimeException("Can't edit config. Index exceeds size.");
    return setNewConfigLike(index, buildConfig(index));
  }
  
  public ConfigNested<A> editFirstConfig() {
    if (config.size() == 0) throw new RuntimeException("Can't edit first config. The list is empty.");
    return setNewConfigLike(0, buildConfig(0));
  }
  
  public ConfigNested<A> editLastConfig() {
    int index = config.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last config. The list is empty.");
    return setNewConfigLike(index, buildConfig(index));
  }
  
  public ConfigNested<A> editMatchingConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<config.size();i++) { 
    if (predicate.test(config.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching config. No match found.");
    return setNewConfigLike(index, buildConfig(index));
  }
  
  public A addToResults(int index,DeviceRequestAllocationResult item) {
    if (this.results == null) {this.results = new ArrayList<DeviceRequestAllocationResultBuilder>();}
    DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
    if (index < 0 || index >= results.size()) {
        _visitables.get("results").add(builder);
        results.add(builder);
    } else {
        _visitables.get("results").add(builder);
        results.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToResults(int index,DeviceRequestAllocationResult item) {
    if (this.results == null) {this.results = new ArrayList<DeviceRequestAllocationResultBuilder>();}
    DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
    if (index < 0 || index >= results.size()) {
        _visitables.get("results").add(builder);
        results.add(builder);
    } else {
        _visitables.get("results").add(builder);
        results.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToResults(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceRequestAllocationResult... items) {
    if (this.results == null) {this.results = new ArrayList<DeviceRequestAllocationResultBuilder>();}
    for (DeviceRequestAllocationResult item : items) {DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  
  public A addAllToResults(Collection<DeviceRequestAllocationResult> items) {
    if (this.results == null) {this.results = new ArrayList<DeviceRequestAllocationResultBuilder>();}
    for (DeviceRequestAllocationResult item : items) {DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  
  public A removeFromResults(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceRequestAllocationResult... items) {
    if (this.results == null) return (A)this;
    for (DeviceRequestAllocationResult item : items) {DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);_visitables.get("results").remove(builder); this.results.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResults(Collection<DeviceRequestAllocationResult> items) {
    if (this.results == null) return (A)this;
    for (DeviceRequestAllocationResult item : items) {DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);_visitables.get("results").remove(builder); this.results.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResults(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
    if (results == null) return (A) this;
    final Iterator<DeviceRequestAllocationResultBuilder> each = results.iterator();
    final List visitables = _visitables.get("results");
    while (each.hasNext()) {
      DeviceRequestAllocationResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DeviceRequestAllocationResult> buildResults() {
    return this.results != null ? build(results) : null;
  }
  
  public DeviceRequestAllocationResult buildResult(int index) {
    return this.results.get(index).build();
  }
  
  public DeviceRequestAllocationResult buildFirstResult() {
    return this.results.get(0).build();
  }
  
  public DeviceRequestAllocationResult buildLastResult() {
    return this.results.get(results.size() - 1).build();
  }
  
  public DeviceRequestAllocationResult buildMatchingResult(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
      for (DeviceRequestAllocationResultBuilder item : results) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResult(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
      for (DeviceRequestAllocationResultBuilder item : results) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResults(List<DeviceRequestAllocationResult> results) {
    if (this.results != null) {
      this._visitables.get("results").clear();
    }
    if (results != null) {
        this.results = new ArrayList();
        for (DeviceRequestAllocationResult item : results) {
          this.addToResults(item);
        }
    } else {
      this.results = null;
    }
    return (A) this;
  }
  
  public A withResults(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceRequestAllocationResult... results) {
    if (this.results != null) {
        this.results.clear();
        _visitables.remove("results");
    }
    if (results != null) {
      for (DeviceRequestAllocationResult item : results) {
        this.addToResults(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResults() {
    return this.results != null && !this.results.isEmpty();
  }
  
  public ResultsNested<A> addNewResult() {
    return new ResultsNested(-1, null);
  }
  
  public ResultsNested<A> addNewResultLike(DeviceRequestAllocationResult item) {
    return new ResultsNested(-1, item);
  }
  
  public ResultsNested<A> setNewResultLike(int index,DeviceRequestAllocationResult item) {
    return new ResultsNested(index, item);
  }
  
  public ResultsNested<A> editResult(int index) {
    if (results.size() <= index) throw new RuntimeException("Can't edit results. Index exceeds size.");
    return setNewResultLike(index, buildResult(index));
  }
  
  public ResultsNested<A> editFirstResult() {
    if (results.size() == 0) throw new RuntimeException("Can't edit first results. The list is empty.");
    return setNewResultLike(0, buildResult(0));
  }
  
  public ResultsNested<A> editLastResult() {
    int index = results.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last results. The list is empty.");
    return setNewResultLike(index, buildResult(index));
  }
  
  public ResultsNested<A> editMatchingResult(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<results.size();i++) { 
    if (predicate.test(results.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching results. No match found.");
    return setNewResultLike(index, buildResult(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeviceAllocationResultFluent that = (DeviceAllocationResultFluent) o;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(results, that.results)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(config,  results,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (results != null && !results.isEmpty()) { sb.append("results:"); sb.append(results + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigNested<N> extends DeviceAllocationConfigurationFluent<ConfigNested<N>> implements Nested<N>{
    ConfigNested(int index,DeviceAllocationConfiguration item) {
      this.index = index;
      this.builder = new DeviceAllocationConfigurationBuilder(this, item);
    }
    DeviceAllocationConfigurationBuilder builder;
    int index;
    
    public N and() {
      return (N) DeviceAllocationResultFluent.this.setToConfig(index,builder.build());
    }
    
    public N endConfig() {
      return and();
    }
    
  
  }
  public class ResultsNested<N> extends DeviceRequestAllocationResultFluent<ResultsNested<N>> implements Nested<N>{
    ResultsNested(int index,DeviceRequestAllocationResult item) {
      this.index = index;
      this.builder = new DeviceRequestAllocationResultBuilder(this, item);
    }
    DeviceRequestAllocationResultBuilder builder;
    int index;
    
    public N and() {
      return (N) DeviceAllocationResultFluent.this.setToResults(index,builder.build());
    }
    
    public N endResult() {
      return and();
    }
    
  
  }

}