package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedResourcesResourcesFluent<A extends NamedResourcesResourcesFluent<A>> extends BaseFluent<A>{
  public NamedResourcesResourcesFluent() {
  }
  
  public NamedResourcesResourcesFluent(NamedResourcesResources instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NamedResourcesInstanceBuilder> instances = new ArrayList<NamedResourcesInstanceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedResourcesResources instance) {
    instance = (instance != null ? instance : new NamedResourcesResources());
    if (instance != null) {
          this.withInstances(instance.getInstances());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToInstances(int index,NamedResourcesInstance item) {
    if (this.instances == null) {this.instances = new ArrayList<NamedResourcesInstanceBuilder>();}
    NamedResourcesInstanceBuilder builder = new NamedResourcesInstanceBuilder(item);
    if (index < 0 || index >= instances.size()) {
        _visitables.get("instances").add(builder);
        instances.add(builder);
    } else {
        _visitables.get("instances").add(builder);
        instances.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToInstances(int index,NamedResourcesInstance item) {
    if (this.instances == null) {this.instances = new ArrayList<NamedResourcesInstanceBuilder>();}
    NamedResourcesInstanceBuilder builder = new NamedResourcesInstanceBuilder(item);
    if (index < 0 || index >= instances.size()) {
        _visitables.get("instances").add(builder);
        instances.add(builder);
    } else {
        _visitables.get("instances").add(builder);
        instances.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToInstances(io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesInstance... items) {
    if (this.instances == null) {this.instances = new ArrayList<NamedResourcesInstanceBuilder>();}
    for (NamedResourcesInstance item : items) {NamedResourcesInstanceBuilder builder = new NamedResourcesInstanceBuilder(item);_visitables.get("instances").add(builder);this.instances.add(builder);} return (A)this;
  }
  
  public A addAllToInstances(Collection<NamedResourcesInstance> items) {
    if (this.instances == null) {this.instances = new ArrayList<NamedResourcesInstanceBuilder>();}
    for (NamedResourcesInstance item : items) {NamedResourcesInstanceBuilder builder = new NamedResourcesInstanceBuilder(item);_visitables.get("instances").add(builder);this.instances.add(builder);} return (A)this;
  }
  
  public A removeFromInstances(io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesInstance... items) {
    if (this.instances == null) return (A)this;
    for (NamedResourcesInstance item : items) {NamedResourcesInstanceBuilder builder = new NamedResourcesInstanceBuilder(item);_visitables.get("instances").remove(builder); this.instances.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInstances(Collection<NamedResourcesInstance> items) {
    if (this.instances == null) return (A)this;
    for (NamedResourcesInstance item : items) {NamedResourcesInstanceBuilder builder = new NamedResourcesInstanceBuilder(item);_visitables.get("instances").remove(builder); this.instances.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInstances(Predicate<NamedResourcesInstanceBuilder> predicate) {
    if (instances == null) return (A) this;
    final Iterator<NamedResourcesInstanceBuilder> each = instances.iterator();
    final List visitables = _visitables.get("instances");
    while (each.hasNext()) {
      NamedResourcesInstanceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedResourcesInstance> buildInstances() {
    return this.instances != null ? build(instances) : null;
  }
  
  public NamedResourcesInstance buildInstance(int index) {
    return this.instances.get(index).build();
  }
  
  public NamedResourcesInstance buildFirstInstance() {
    return this.instances.get(0).build();
  }
  
  public NamedResourcesInstance buildLastInstance() {
    return this.instances.get(instances.size() - 1).build();
  }
  
  public NamedResourcesInstance buildMatchingInstance(Predicate<NamedResourcesInstanceBuilder> predicate) {
      for (NamedResourcesInstanceBuilder item : instances) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInstance(Predicate<NamedResourcesInstanceBuilder> predicate) {
      for (NamedResourcesInstanceBuilder item : instances) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withInstances(List<NamedResourcesInstance> instances) {
    if (this.instances != null) {
      this._visitables.get("instances").clear();
    }
    if (instances != null) {
        this.instances = new ArrayList();
        for (NamedResourcesInstance item : instances) {
          this.addToInstances(item);
        }
    } else {
      this.instances = null;
    }
    return (A) this;
  }
  
  public A withInstances(io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesInstance... instances) {
    if (this.instances != null) {
        this.instances.clear();
        _visitables.remove("instances");
    }
    if (instances != null) {
      for (NamedResourcesInstance item : instances) {
        this.addToInstances(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasInstances() {
    return this.instances != null && !this.instances.isEmpty();
  }
  
  public InstancesNested<A> addNewInstance() {
    return new InstancesNested(-1, null);
  }
  
  public InstancesNested<A> addNewInstanceLike(NamedResourcesInstance item) {
    return new InstancesNested(-1, item);
  }
  
  public InstancesNested<A> setNewInstanceLike(int index,NamedResourcesInstance item) {
    return new InstancesNested(index, item);
  }
  
  public InstancesNested<A> editInstance(int index) {
    if (instances.size() <= index) throw new RuntimeException("Can't edit instances. Index exceeds size.");
    return setNewInstanceLike(index, buildInstance(index));
  }
  
  public InstancesNested<A> editFirstInstance() {
    if (instances.size() == 0) throw new RuntimeException("Can't edit first instances. The list is empty.");
    return setNewInstanceLike(0, buildInstance(0));
  }
  
  public InstancesNested<A> editLastInstance() {
    int index = instances.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last instances. The list is empty.");
    return setNewInstanceLike(index, buildInstance(index));
  }
  
  public InstancesNested<A> editMatchingInstance(Predicate<NamedResourcesInstanceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<instances.size();i++) { 
    if (predicate.test(instances.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching instances. No match found.");
    return setNewInstanceLike(index, buildInstance(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedResourcesResourcesFluent that = (NamedResourcesResourcesFluent) o;
    if (!java.util.Objects.equals(instances, that.instances)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(instances,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (instances != null && !instances.isEmpty()) { sb.append("instances:"); sb.append(instances + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InstancesNested<N> extends NamedResourcesInstanceFluent<InstancesNested<N>> implements Nested<N>{
    InstancesNested(int index,NamedResourcesInstance item) {
      this.index = index;
      this.builder = new NamedResourcesInstanceBuilder(this, item);
    }
    NamedResourcesInstanceBuilder builder;
    int index;
    
    public N and() {
      return (N) NamedResourcesResourcesFluent.this.setToInstances(index,builder.build());
    }
    
    public N endInstance() {
      return and();
    }
    
  
  }

}