/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesRequest;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesRequestBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesRequestFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceRequest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceRequestFluent<A extends ResourceRequestFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private NamedResourcesRequestBuilder namedResources;
    private Object vendorParameters;

    public ResourceRequestFluent() {
    }

    public ResourceRequestFluent(ResourceRequest instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public NamedResourcesRequest buildNamedResources() {
        return this.namedResources != null ? this.namedResources.build() : null;
    }

    protected void copyInstance(ResourceRequest instance) {
        ResourceRequest resourceRequest = instance = instance != null ? instance : new ResourceRequest();
        if (instance != null) {
            this.withNamedResources(instance.getNamedResources());
            this.withVendorParameters(instance.getVendorParameters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NamedResourcesNested<A> editNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(null));
    }

    public NamedResourcesNested<A> editOrNewNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(new NamedResourcesRequestBuilder().build()));
    }

    public NamedResourcesNested<A> editOrNewNamedResourcesLike(NamedResourcesRequest item) {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequestFluent that = (ResourceRequestFluent)((Object)o);
        if (!Objects.equals((Object)this.namedResources, (Object)that.namedResources)) {
            return false;
        }
        if (!Objects.equals(this.vendorParameters, that.vendorParameters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getVendorParameters() {
        return this.vendorParameters;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasNamedResources() {
        return this.namedResources != null;
    }

    public boolean hasVendorParameters() {
        return this.vendorParameters != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namedResources, this.vendorParameters, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namedResources != null) {
            sb.append("namedResources:");
            sb.append((Object)this.namedResources);
            sb.append(",");
        }
        if (this.vendorParameters != null) {
            sb.append("vendorParameters:");
            sb.append(this.vendorParameters);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withNamedResources(NamedResourcesRequest namedResources) {
        this._visitables.remove((Object)"namedResources");
        if (namedResources != null) {
            this.namedResources = new NamedResourcesRequestBuilder(namedResources);
            this._visitables.get((Object)"namedResources").add(this.namedResources);
        } else {
            this.namedResources = null;
            this._visitables.get((Object)"namedResources").remove((Object)this.namedResources);
        }
        return (A)((Object)this);
    }

    public NamedResourcesNested<A> withNewNamedResources() {
        return new NamedResourcesNested(null);
    }

    public A withNewNamedResources(String selector) {
        return this.withNamedResources(new NamedResourcesRequest(selector));
    }

    public NamedResourcesNested<A> withNewNamedResourcesLike(NamedResourcesRequest item) {
        return new NamedResourcesNested(item);
    }

    public A withVendorParameters(Object vendorParameters) {
        this.vendorParameters = vendorParameters;
        return (A)((Object)this);
    }

    public class NamedResourcesNested<N>
    extends NamedResourcesRequestFluent<NamedResourcesNested<N>>
    implements Nested<N> {
        NamedResourcesRequestBuilder builder;

        NamedResourcesNested(NamedResourcesRequest item) {
            this.builder = new NamedResourcesRequestBuilder(this, item);
        }

        public N and() {
            return (N)ResourceRequestFluent.this.withNamedResources(this.builder.build());
        }

        public N endNamedResources() {
            return this.and();
        }
    }
}

