package io.fabric8.kubernetes.api.model.settings;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodPresetListFluent<A extends PodPresetListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,PodPreset item);
    public A setToItems(int index,PodPreset item);
    public A addToItems(PodPreset... items);
    public A addAllToItems(Collection<PodPreset> items);
    public A removeFromItems(PodPreset... items);
    public A removeAllFromItems(Collection<PodPreset> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<PodPresetBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PodPreset> getItems();
    public List<PodPreset> buildItems();
    public PodPreset buildItem(int index);
    public PodPreset buildFirstItem();
    public PodPreset buildLastItem();
    public PodPreset buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PodPresetBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PodPresetBuilder> predicate);
    public A withItems(List<PodPreset> items);
    public A withItems(PodPreset... items);
    public Boolean hasItems();
    public PodPresetListFluent.ItemsNested<A> addNewItem();
    public PodPresetListFluent.ItemsNested<A> addNewItemLike(PodPreset item);
    public PodPresetListFluent.ItemsNested<A> setNewItemLike(int index,PodPreset item);
    public PodPresetListFluent.ItemsNested<A> editItem(int index);
    public PodPresetListFluent.ItemsNested<A> editFirstItem();
    public PodPresetListFluent.ItemsNested<A> editLastItem();
    public PodPresetListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PodPresetBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodPresetFluent<PodPresetListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
