package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class VolumeAttachmentBuilder extends io.fabric8.kubernetes.api.model.storage.VolumeAttachmentFluentImpl<io.fabric8.kubernetes.api.model.storage.VolumeAttachmentBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.VolumeAttachment,io.fabric8.kubernetes.api.model.storage.VolumeAttachmentBuilder>{
  public VolumeAttachmentBuilder() {
    this(false);
  }
  public VolumeAttachmentBuilder(java.lang.Boolean validationEnabled) {
    this(new VolumeAttachment(), validationEnabled);
  }
  public VolumeAttachmentBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeAttachmentBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VolumeAttachment(), validationEnabled);
  }
  public VolumeAttachmentBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.VolumeAttachment instance) {
    this(fluent, instance, false);
  }
  public VolumeAttachmentBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.VolumeAttachment instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeAttachmentBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachment instance) {
    this(instance,false);
  }
  public VolumeAttachmentBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachment instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.storage.VolumeAttachmentFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.storage.VolumeAttachment build() {
    VolumeAttachment buildable = new VolumeAttachment(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeAttachmentBuilder that = (VolumeAttachmentBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}