package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class CSIStorageCapacityBuilder extends io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluentImpl<io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity,io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityBuilder>{
  public CSIStorageCapacityBuilder() {
    this(false);
  }
  public CSIStorageCapacityBuilder(java.lang.Boolean validationEnabled) {
    this(new CSIStorageCapacity(), validationEnabled);
  }
  public CSIStorageCapacityBuilder(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIStorageCapacityBuilder(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CSIStorageCapacity(), validationEnabled);
  }
  public CSIStorageCapacityBuilder(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity instance) {
    this(fluent, instance, false);
  }
  public CSIStorageCapacityBuilder(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMaximumVolumeSize(instance.getMaximumVolumeSize()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withNodeTopology(instance.getNodeTopology()); 
    fluent.withStorageClassName(instance.getStorageClassName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSIStorageCapacityBuilder(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity instance) {
    this(instance,false);
  }
  public CSIStorageCapacityBuilder(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCapacity(instance.getCapacity()); 
    this.withKind(instance.getKind()); 
    this.withMaximumVolumeSize(instance.getMaximumVolumeSize()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNodeTopology(instance.getNodeTopology()); 
    this.withStorageClassName(instance.getStorageClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity build() {
    CSIStorageCapacity buildable = new CSIStorageCapacity(fluent.getApiVersion(),fluent.getCapacity(),fluent.getKind(),fluent.getMaximumVolumeSize(),fluent.getMetadata(),fluent.getNodeTopology(),fluent.getStorageClassName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSIStorageCapacityBuilder that = (CSIStorageCapacityBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}