package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentSourceBuilder extends io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluentImpl<io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource,io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceBuilder> {

    io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public VolumeAttachmentSourceBuilder() {
        this(true);
    }

    public VolumeAttachmentSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new VolumeAttachmentSource(), validationEnabled);
    }

    public VolumeAttachmentSourceBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public VolumeAttachmentSourceBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new VolumeAttachmentSource(), validationEnabled);
    }

    public VolumeAttachmentSourceBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource instance) {
        this(fluent, instance, true);
    }

    public VolumeAttachmentSourceBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
        fluent.withPersistentVolumeName(instance.getPersistentVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentSourceBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource instance) {
        this(instance,true);
    }

    public VolumeAttachmentSourceBuilder(io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
        this.withPersistentVolumeName(instance.getPersistentVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource build() {
        VolumeAttachmentSource buildable = new VolumeAttachmentSource(fluent.getInlineVolumeSpec(),fluent.getPersistentVolumeName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeAttachmentSourceBuilder that = (VolumeAttachmentSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
