package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIDriverBuilder extends CSIDriverFluentImpl<CSIDriverBuilder> implements VisitableBuilder<CSIDriver,CSIDriverBuilder>{
  public CSIDriverBuilder() {
    this(false);
  }
  public CSIDriverBuilder(Boolean validationEnabled) {
    this(new CSIDriver(), validationEnabled);
  }
  public CSIDriverBuilder(CSIDriverFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIDriverBuilder(CSIDriverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIDriver(), validationEnabled);
  }
  public CSIDriverBuilder(CSIDriverFluent<?> fluent,CSIDriver instance) {
    this(fluent, instance, false);
  }
  public CSIDriverBuilder(CSIDriverFluent<?> fluent,CSIDriver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSIDriverBuilder(CSIDriver instance) {
    this(instance,false);
  }
  public CSIDriverBuilder(CSIDriver instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSIDriverFluent<?> fluent;
  Boolean validationEnabled;
  public CSIDriver build() {
    CSIDriver buildable = new CSIDriver(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}