package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CSIStorageCapacityFluent<A extends CSIStorageCapacityFluent<A>> extends BaseFluent<A>{
  public CSIStorageCapacityFluent() {
  }
  public CSIStorageCapacityFluent(CSIStorageCapacity instance) {
    instance = (instance != null ? instance : new CSIStorageCapacity());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withCapacity(instance.getCapacity());
      this.withKind(instance.getKind());
      this.withMaximumVolumeSize(instance.getMaximumVolumeSize());
      this.withMetadata(instance.getMetadata());
      this.withNodeTopology(instance.getNodeTopology());
      this.withStorageClassName(instance.getStorageClassName());
      this.withApiVersion(instance.getApiVersion());
      this.withCapacity(instance.getCapacity());
      this.withKind(instance.getKind());
      this.withMaximumVolumeSize(instance.getMaximumVolumeSize());
      this.withMetadata(instance.getMetadata());
      this.withNodeTopology(instance.getNodeTopology());
      this.withStorageClassName(instance.getStorageClassName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private Quantity capacity;
  private String kind;
  private Quantity maximumVolumeSize;
  private ObjectMetaBuilder metadata;
  private LabelSelectorBuilder nodeTopology;
  private String storageClassName;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public Quantity getCapacity() {
    return this.capacity;
  }
  public A withCapacity(Quantity capacity) {
    this.capacity=capacity; return (A) this;
  }
  public boolean hasCapacity() {
    return this.capacity != null;
  }
  public A withNewCapacity(String amount,String format) {
    return (A)withCapacity(new Quantity(amount, format));
  }
  public A withNewCapacity(String amount) {
    return (A)withCapacity(new Quantity(amount));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public Quantity getMaximumVolumeSize() {
    return this.maximumVolumeSize;
  }
  public A withMaximumVolumeSize(Quantity maximumVolumeSize) {
    this.maximumVolumeSize=maximumVolumeSize; return (A) this;
  }
  public boolean hasMaximumVolumeSize() {
    return this.maximumVolumeSize != null;
  }
  public A withNewMaximumVolumeSize(String amount,String format) {
    return (A)withMaximumVolumeSize(new Quantity(amount, format));
  }
  public A withNewMaximumVolumeSize(String amount) {
    return (A)withMaximumVolumeSize(new Quantity(amount));
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public LabelSelector buildNodeTopology() {
    return this.nodeTopology!=null ?this.nodeTopology.build():null;
  }
  public A withNodeTopology(LabelSelector nodeTopology) {
    _visitables.get("nodeTopology").remove(this.nodeTopology);
    if (nodeTopology!=null){ this.nodeTopology= new LabelSelectorBuilder(nodeTopology); _visitables.get("nodeTopology").add(this.nodeTopology);} else { this.nodeTopology = null; _visitables.get("nodeTopology").remove(this.nodeTopology); } return (A) this;
  }
  public boolean hasNodeTopology() {
    return this.nodeTopology != null;
  }
  public NodeTopologyNested<A> withNewNodeTopology() {
    return new NodeTopologyNested(null);
  }
  public NodeTopologyNested<A> withNewNodeTopologyLike(LabelSelector item) {
    return new NodeTopologyNested(item);
  }
  public NodeTopologyNested<A> editNodeTopology() {
    return withNewNodeTopologyLike(java.util.Optional.ofNullable(buildNodeTopology()).orElse(null));
  }
  public NodeTopologyNested<A> editOrNewNodeTopology() {
    return withNewNodeTopologyLike(java.util.Optional.ofNullable(buildNodeTopology()).orElse(new LabelSelectorBuilder().build()));
  }
  public NodeTopologyNested<A> editOrNewNodeTopologyLike(LabelSelector item) {
    return withNewNodeTopologyLike(java.util.Optional.ofNullable(buildNodeTopology()).orElse(item));
  }
  public String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSIStorageCapacityFluent that = (CSIStorageCapacityFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(capacity, that.capacity)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(maximumVolumeSize, that.maximumVolumeSize)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(nodeTopology, that.nodeTopology)) return false;

    if (!java.util.Objects.equals(storageClassName, that.storageClassName)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  capacity,  kind,  maximumVolumeSize,  metadata,  nodeTopology,  storageClassName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (capacity != null) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (maximumVolumeSize != null) { sb.append("maximumVolumeSize:"); sb.append(maximumVolumeSize + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (nodeTopology != null) { sb.append("nodeTopology:"); sb.append(nodeTopology + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) CSIStorageCapacityFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class NodeTopologyNested<N> extends LabelSelectorFluent<NodeTopologyNested<N>> implements Nested<N>{
    NodeTopologyNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) CSIStorageCapacityFluent.this.withNodeTopology(builder.build());
    }
    public N endNodeTopology() {
      return and();
    }
    
  }
  
}