package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIStorageCapacityListBuilder extends CSIStorageCapacityListFluent<CSIStorageCapacityListBuilder> implements VisitableBuilder<CSIStorageCapacityList,CSIStorageCapacityListBuilder>{
  public CSIStorageCapacityListBuilder() {
    this(false);
  }
  public CSIStorageCapacityListBuilder(Boolean validationEnabled) {
    this(new CSIStorageCapacityList(), validationEnabled);
  }
  public CSIStorageCapacityListBuilder(CSIStorageCapacityListFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIStorageCapacityListBuilder(CSIStorageCapacityListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIStorageCapacityList(), validationEnabled);
  }
  public CSIStorageCapacityListBuilder(CSIStorageCapacityListFluent<?> fluent,CSIStorageCapacityList instance) {
    this(fluent, instance, false);
  }
  public CSIStorageCapacityListBuilder(CSIStorageCapacityListFluent<?> fluent,CSIStorageCapacityList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSIStorageCapacityList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSIStorageCapacityListBuilder(CSIStorageCapacityList instance) {
    this(instance,false);
  }
  public CSIStorageCapacityListBuilder(CSIStorageCapacityList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSIStorageCapacityList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSIStorageCapacityListFluent<?> fluent;
  Boolean validationEnabled;
  public CSIStorageCapacityList build() {
    CSIStorageCapacityList buildable = new CSIStorageCapacityList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}