package io.fabric8.kubernetes.api.model.storage;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VolumeAttachmentSpecFluent<A extends VolumeAttachmentSpecFluent<A>> extends BaseFluent<A>{
  public VolumeAttachmentSpecFluent() {
  }
  
  public VolumeAttachmentSpecFluent(VolumeAttachmentSpec instance) {
    this.copyInstance(instance);
  }
  private String attacher;
  private String nodeName;
  private VolumeAttachmentSourceBuilder source;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VolumeAttachmentSpec instance) {
    instance = (instance != null ? instance : new VolumeAttachmentSpec());
  
    if (instance != null) {
        this.withAttacher(instance.getAttacher());
        this.withNodeName(instance.getNodeName());
        this.withSource(instance.getSource());
        this.withAttacher(instance.getAttacher());
        this.withNodeName(instance.getNodeName());
        this.withSource(instance.getSource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getAttacher() {
    return this.attacher;
  }
  
  public A withAttacher(String attacher) {
    this.attacher=attacher; return (A) this;
  }
  
  public boolean hasAttacher() {
    return this.attacher != null;
  }
  
  public String getNodeName() {
    return this.nodeName;
  }
  
  public A withNodeName(String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  
  public boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  public VolumeAttachmentSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  
  public A withSource(VolumeAttachmentSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new VolumeAttachmentSourceBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public SourceNested<A> withNewSource() {
    return new SourceNested(null);
  }
  
  public SourceNested<A> withNewSourceLike(VolumeAttachmentSource item) {
    return new SourceNested(item);
  }
  
  public SourceNested<A> editSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(null));
  }
  
  public SourceNested<A> editOrNewSource() {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(new VolumeAttachmentSourceBuilder().build()));
  }
  
  public SourceNested<A> editOrNewSourceLike(VolumeAttachmentSource item) {
    return withNewSourceLike(java.util.Optional.ofNullable(buildSource()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeAttachmentSpecFluent that = (VolumeAttachmentSpecFluent) o;
    if (!java.util.Objects.equals(attacher, that.attacher)) return false;
  
    if (!java.util.Objects.equals(nodeName, that.nodeName)) return false;
  
    if (!java.util.Objects.equals(source, that.source)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attacher,  nodeName,  source,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attacher != null) { sb.append("attacher:"); sb.append(attacher + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SourceNested<N> extends VolumeAttachmentSourceFluent<SourceNested<N>> implements Nested<N>{
    SourceNested(VolumeAttachmentSource item) {
      this.builder = new VolumeAttachmentSourceBuilder(this, item);
    }
    VolumeAttachmentSourceBuilder builder;
    
    public N and() {
      return (N) VolumeAttachmentSpecFluent.this.withSource(builder.build());
    }
    
    public N endSource() {
      return and();
    }
    
  
  }

}