package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CSINodeSpecFluent<A extends CSINodeSpecFluent<A>> extends BaseFluent<A>{
  public CSINodeSpecFluent() {
  }
  
  public CSINodeSpecFluent(CSINodeSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CSINodeDriverBuilder> drivers = new ArrayList<CSINodeDriverBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CSINodeSpec instance) {
    instance = (instance != null ? instance : new CSINodeSpec());
    if (instance != null) {
          this.withDrivers(instance.getDrivers());
          this.withDrivers(instance.getDrivers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDrivers(int index,CSINodeDriver item) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
    if (index < 0 || index >= drivers.size()) { _visitables.get("drivers").add(builder); drivers.add(builder); } else { _visitables.get("drivers").add(index, builder); drivers.add(index, builder);}
    return (A)this;
  }
  
  public A setToDrivers(int index,CSINodeDriver item) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
    if (index < 0 || index >= drivers.size()) { _visitables.get("drivers").add(builder); drivers.add(builder); } else { _visitables.get("drivers").set(index, builder); drivers.set(index, builder);}
    return (A)this;
  }
  
  public A addToDrivers(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver... items) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
  }
  
  public A addAllToDrivers(Collection<CSINodeDriver> items) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
  }
  
  public A removeFromDrivers(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver... items) {
    if (this.drivers == null) return (A)this;
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder); this.drivers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDrivers(Collection<CSINodeDriver> items) {
    if (this.drivers == null) return (A)this;
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder); this.drivers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDrivers(Predicate<CSINodeDriverBuilder> predicate) {
    if (drivers == null) return (A) this;
    final Iterator<CSINodeDriverBuilder> each = drivers.iterator();
    final List visitables = _visitables.get("drivers");
    while (each.hasNext()) {
      CSINodeDriverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CSINodeDriver> buildDrivers() {
    return this.drivers != null ? build(drivers) : null;
  }
  
  public CSINodeDriver buildDriver(int index) {
    return this.drivers.get(index).build();
  }
  
  public CSINodeDriver buildFirstDriver() {
    return this.drivers.get(0).build();
  }
  
  public CSINodeDriver buildLastDriver() {
    return this.drivers.get(drivers.size() - 1).build();
  }
  
  public CSINodeDriver buildMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
      for (CSINodeDriverBuilder item : drivers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
      for (CSINodeDriverBuilder item : drivers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDrivers(List<CSINodeDriver> drivers) {
    if (this.drivers != null) {
      this._visitables.get("drivers").clear();
    }
    if (drivers != null) {
        this.drivers = new ArrayList();
        for (CSINodeDriver item : drivers) {
          this.addToDrivers(item);
        }
    } else {
      this.drivers = null;
    }
    return (A) this;
  }
  
  public A withDrivers(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver... drivers) {
    if (this.drivers != null) {this.drivers.clear(); _visitables.remove("drivers"); }
    if (drivers != null) {for (CSINodeDriver item :drivers){ this.addToDrivers(item);}} return (A) this;
  }
  
  public boolean hasDrivers() {
    return this.drivers != null && !this.drivers.isEmpty();
  }
  
  public DriversNested<A> addNewDriver() {
    return new DriversNested(-1, null);
  }
  
  public DriversNested<A> addNewDriverLike(CSINodeDriver item) {
    return new DriversNested(-1, item);
  }
  
  public DriversNested<A> setNewDriverLike(int index,CSINodeDriver item) {
    return new DriversNested(index, item);
  }
  
  public DriversNested<A> editDriver(int index) {
    if (drivers.size() <= index) throw new RuntimeException("Can't edit drivers. Index exceeds size.");
    return setNewDriverLike(index, buildDriver(index));
  }
  
  public DriversNested<A> editFirstDriver() {
    if (drivers.size() == 0) throw new RuntimeException("Can't edit first drivers. The list is empty.");
    return setNewDriverLike(0, buildDriver(0));
  }
  
  public DriversNested<A> editLastDriver() {
    int index = drivers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last drivers. The list is empty.");
    return setNewDriverLike(index, buildDriver(index));
  }
  
  public DriversNested<A> editMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<drivers.size();i++) { 
    if (predicate.test(drivers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching drivers. No match found.");
    return setNewDriverLike(index, buildDriver(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSINodeSpecFluent that = (CSINodeSpecFluent) o;
    if (!java.util.Objects.equals(drivers, that.drivers)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(drivers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (drivers != null && !drivers.isEmpty()) { sb.append("drivers:"); sb.append(drivers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DriversNested<N> extends CSINodeDriverFluent<DriversNested<N>> implements Nested<N>{
    DriversNested(int index,CSINodeDriver item) {
      this.index = index;
      this.builder = new CSINodeDriverBuilder(this, item);
    }
    CSINodeDriverBuilder builder;
    int index;
    
    public N and() {
      return (N) CSINodeSpecFluent.this.setToDrivers(index,builder.build());
    }
    
    public N endDriver() {
      return and();
    }
    
  
  }

}