/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.rbac.KubernetesPolicyRule;
import io.fabric8.kubernetes.api.model.rbac.KubernetesPolicyRuleBuilder;
import io.fabric8.kubernetes.api.model.rbac.KubernetesPolicyRuleFluentImpl;
import io.fabric8.kubernetes.api.model.rbac.KubernetesRole;
import io.fabric8.kubernetes.api.model.rbac.KubernetesRoleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KubernetesRoleFluentImpl<A extends KubernetesRoleFluent<A>>
extends BaseFluent<A>
implements KubernetesRoleFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<KubernetesPolicyRuleBuilder> rules;

    public KubernetesRoleFluentImpl() {
    }

    public KubernetesRoleFluentImpl(KubernetesRole instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public KubernetesRoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public KubernetesRoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public KubernetesRoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public KubernetesRoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public KubernetesRoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, KubernetesPolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, KubernetesPolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(KubernetesPolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<KubernetesPolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(KubernetesPolicyRule ... items) {
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<KubernetesPolicyRule> items) {
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KubernetesPolicyRule> getRules() {
        return KubernetesRoleFluentImpl.build(this.rules);
    }

    @Override
    public List<KubernetesPolicyRule> buildRules() {
        return KubernetesRoleFluentImpl.build(this.rules);
    }

    @Override
    public KubernetesPolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public KubernetesPolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public KubernetesPolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public KubernetesPolicyRule buildMatchingRule(Predicate<KubernetesPolicyRuleBuilder> predicate) {
        for (KubernetesPolicyRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRules(List<KubernetesPolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
            for (KubernetesPolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withRules(KubernetesPolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (KubernetesPolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> addNewRuleLike(KubernetesPolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> setNewRuleLike(int index, KubernetesPolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public KubernetesRoleFluent.RulesNested<A> editMatchingRule(Predicate<KubernetesPolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesRoleFluentImpl that = (KubernetesRoleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public class RulesNestedImpl<N>
    extends KubernetesPolicyRuleFluentImpl<KubernetesRoleFluent.RulesNested<N>>
    implements KubernetesRoleFluent.RulesNested<N>,
    Nested<N> {
        private final KubernetesPolicyRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, KubernetesPolicyRule item) {
            this.index = index;
            this.builder = new KubernetesPolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new KubernetesPolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesRoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<KubernetesRoleFluent.MetadataNested<N>>
    implements KubernetesRoleFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesRoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

