package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KubernetesRoleBindingFluent<A extends KubernetesRoleBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KubernetesRoleBindingFluent.MetadataNested<A> withNewMetadata();
    public KubernetesRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KubernetesRoleBindingFluent.MetadataNested<A> editMetadata();
    public KubernetesRoleBindingFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public KubernetesRoleRef getRoleRef();
    public KubernetesRoleRef buildRoleRef();
    public A withRoleRef(KubernetesRoleRef roleRef);
    public Boolean hasRoleRef();
    public A withNewRoleRef(String apiGroup,String kind,String name);
    public KubernetesRoleBindingFluent.RoleRefNested<A> withNewRoleRef();
    public KubernetesRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(KubernetesRoleRef item);
    public KubernetesRoleBindingFluent.RoleRefNested<A> editRoleRef();
    public KubernetesRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef();
    public KubernetesRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(KubernetesRoleRef item);
    public A addToSubjects(int index,KubernetesSubject item);
    public A setToSubjects(int index,KubernetesSubject item);
    public A addToSubjects(KubernetesSubject... items);
    public A addAllToSubjects(Collection<KubernetesSubject> items);
    public A removeFromSubjects(KubernetesSubject... items);
    public A removeAllFromSubjects(Collection<KubernetesSubject> items);
    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<KubernetesSubject> getSubjects();
    public List<KubernetesSubject> buildSubjects();
    public KubernetesSubject buildSubject(int index);
    public KubernetesSubject buildFirstSubject();
    public KubernetesSubject buildLastSubject();
    public KubernetesSubject buildMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<KubernetesSubjectBuilder> predicate);
    public A withSubjects(List<KubernetesSubject> subjects);
    public A withSubjects(KubernetesSubject... subjects);
    public Boolean hasSubjects();
    public A addNewSubject(String apiGroup,String kind,String name,String namespace);
    public KubernetesRoleBindingFluent.SubjectsNested<A> addNewSubject();
    public KubernetesRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(KubernetesSubject item);
    public KubernetesRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,KubernetesSubject item);
    public KubernetesRoleBindingFluent.SubjectsNested<A> editSubject(int index);
    public KubernetesRoleBindingFluent.SubjectsNested<A> editFirstSubject();
    public KubernetesRoleBindingFluent.SubjectsNested<A> editLastSubject();
    public KubernetesRoleBindingFluent.SubjectsNested<A> editMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<KubernetesSubjectBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KubernetesRoleBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RoleRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesRoleRefFluent<KubernetesRoleBindingFluent.RoleRefNested<N>>{

        
    public N and();    public N endRoleRef();
}
    public interface SubjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesSubjectFluent<KubernetesRoleBindingFluent.SubjectsNested<N>>{

        
    public N and();    public N endSubject();
}


}
