package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KubernetesRoleFluent<A extends KubernetesRoleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KubernetesRoleFluent.MetadataNested<A> withNewMetadata();
    public KubernetesRoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KubernetesRoleFluent.MetadataNested<A> editMetadata();
    public KubernetesRoleFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesRoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToRules(int index,KubernetesPolicyRule item);
    public A setToRules(int index,KubernetesPolicyRule item);
    public A addToRules(KubernetesPolicyRule... items);
    public A addAllToRules(Collection<KubernetesPolicyRule> items);
    public A removeFromRules(KubernetesPolicyRule... items);
    public A removeAllFromRules(Collection<KubernetesPolicyRule> items);
    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<KubernetesPolicyRule> getRules();
    public List<KubernetesPolicyRule> buildRules();
    public KubernetesPolicyRule buildRule(int index);
    public KubernetesPolicyRule buildFirstRule();
    public KubernetesPolicyRule buildLastRule();
    public KubernetesPolicyRule buildMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<KubernetesPolicyRuleBuilder> predicate);
    public A withRules(List<KubernetesPolicyRule> rules);
    public A withRules(KubernetesPolicyRule... rules);
    public Boolean hasRules();
    public KubernetesRoleFluent.RulesNested<A> addNewRule();
    public KubernetesRoleFluent.RulesNested<A> addNewRuleLike(KubernetesPolicyRule item);
    public KubernetesRoleFluent.RulesNested<A> setNewRuleLike(int index,KubernetesPolicyRule item);
    public KubernetesRoleFluent.RulesNested<A> editRule(int index);
    public KubernetesRoleFluent.RulesNested<A> editFirstRule();
    public KubernetesRoleFluent.RulesNested<A> editLastRule();
    public KubernetesRoleFluent.RulesNested<A> editMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<KubernetesPolicyRuleBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KubernetesRoleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesPolicyRuleFluent<KubernetesRoleFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}


}
