/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildFluentImpl;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuildListFluentImpl<A extends BuildListFluent<A>>
extends BaseFluent<A>
implements BuildListFluent<A> {
    private String apiVersion;
    private List<BuildBuilder> items;
    private String kind;
    private ListMetaBuilder metadata;

    public BuildListFluentImpl() {
    }

    public BuildListFluentImpl(BuildList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, Build item) {
        if (this.items == null) {
            this.items = new ArrayList<BuildBuilder>();
        }
        BuildBuilder builder = new BuildBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Build item) {
        if (this.items == null) {
            this.items = new ArrayList<BuildBuilder>();
        }
        BuildBuilder builder = new BuildBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Build ... items) {
        if (this.items == null) {
            this.items = new ArrayList<BuildBuilder>();
        }
        for (Build item : items) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Build> items) {
        if (this.items == null) {
            this.items = new ArrayList<BuildBuilder>();
        }
        for (Build item : items) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Build ... items) {
        for (Build item : items) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Build> items) {
        for (Build item : items) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Build> getItems() {
        return BuildListFluentImpl.build(this.items);
    }

    @Override
    public List<Build> buildItems() {
        return BuildListFluentImpl.build(this.items);
    }

    @Override
    public Build buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Build buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Build buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Build buildMatchingItem(Predicate<BuildBuilder> predicate) {
        for (BuildBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<Build> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<BuildBuilder>();
            for (Build item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<BuildBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(Build ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Build item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public BuildListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public BuildListFluent.ItemsNested<A> addNewItemLike(Build item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public BuildListFluent.ItemsNested<A> setNewItemLike(int index, Build item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public BuildListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public BuildListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public BuildListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public BuildListFluent.ItemsNested<A> editMatchingItem(Predicate<BuildBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    @Override
    public BuildListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BuildListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BuildListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public BuildListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public BuildListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildListFluentImpl that = (BuildListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<BuildListFluent.MetadataNested<N>>
    implements BuildListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends BuildFluentImpl<BuildListFluent.ItemsNested<N>>
    implements BuildListFluent.ItemsNested<N>,
    Nested<N> {
        private final BuildBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Build item) {
            this.index = index;
            this.builder = new BuildBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new BuildBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

