/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.api.model.APIResource;
import io.fabric8.kubernetes.api.model.APIResourceBuilder;
import io.fabric8.kubernetes.api.model.APIResourceListBuilder;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.server.mock.CustomResourceAware;
import io.fabric8.kubernetes.client.server.mock.KubernetesClientBuilderCustomizer;
import io.fabric8.kubernetes.client.server.mock.Resetable;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.servicecatalog.client.DefaultServiceCatalogClient;
import io.fabric8.servicecatalog.client.NamespacedServiceCatalogClient;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;

public class KubernetesMockServer
extends DefaultMockServer
implements Resetable,
CustomResourceAware {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final Dispatcher dispatcher;
    private VersionInfo versionInfo;
    private List<Pattern> unsupportedPatterns;

    public KubernetesMockServer() {
        this(true);
    }

    public KubernetesMockServer(boolean useHttps) {
        this(new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), useHttps);
    }

    public KubernetesMockServer(MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(new Context(Serialization.jsonMapper()), server, responses, useHttps);
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(context, server, responses, (Dispatcher)new MockDispatcher(responses), useHttps);
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps) {
        this(context, server, responses, dispatcher, useHttps, new VersionInfo.Builder().withMajor("0").withMinor("0").build());
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps, VersionInfo versionInfo) {
        super(context, server, responses, dispatcher, useHttps);
        this.dispatcher = dispatcher;
        this.responses = responses;
        this.versionInfo = versionInfo;
        this.unsupportedPatterns = Collections.emptyList();
    }

    public void onStart() {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.expect().get()).withPath("/")).andReturn(200, (Object)((RootPathsBuilder)new RootPathsBuilder().addToPaths(this.getRootPaths())).build())).always();
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.expect().get()).withPath("/version")).andReply(200, request -> this.versionInfo)).always();
    }

    public void init() {
        this.start();
    }

    public void init(InetAddress address, int port) {
        this.start(address, port);
    }

    public void destroy() {
        this.shutdown();
    }

    public String[] getRootPaths() {
        return new String[]{"/api", "/apis/extensions"};
    }

    public NamespacedKubernetesClient createClient() {
        return this.createClient(new KubernetesClientBuilderCustomizer());
    }

    public NamespacedKubernetesClient createClient(HttpClient.Factory factory) {
        return this.createClient((KubernetesClientBuilder b) -> b.withHttpClientFactory(factory));
    }

    public NamespacedKubernetesClient createClient(Consumer<KubernetesClientBuilder> kubernetesClientBuilderCustomizer) {
        KubernetesClientBuilder kubernetesClientBuilder = new KubernetesClientBuilder().withConfig(this.initConfig());
        kubernetesClientBuilderCustomizer.accept(kubernetesClientBuilder);
        BaseClient client = (BaseClient)kubernetesClientBuilder.build().adapt(BaseClient.class);
        client.setMatchingGroupPredicate(s -> this.unsupportedPatterns.stream().noneMatch(p -> p.matcher((CharSequence)s).find()));
        return (NamespacedKubernetesClient)client.adapt(NamespacedKubernetesClient.class);
    }

    public final void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = Objects.requireNonNull(versionInfo);
    }

    public void setUnsupported(String ... unsupported) {
        this.unsupportedPatterns = new ArrayList<Pattern>(unsupported.length);
        for (int i = 0; i < unsupported.length; ++i) {
            String asRegex = unsupported[i].replace(".", "\\.").replace("*", ".*");
            if (!asRegex.contains("/")) {
                asRegex = asRegex + "(/.*)?";
            }
            asRegex = asRegex + "$";
            this.unsupportedPatterns.add(Pattern.compile(asRegex));
        }
    }

    public void clearExpectations() {
        this.responses.clear();
    }

    protected Config initConfig() {
        NamedContext mockServerContext = ((NamedContextBuilder)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextBuilder)new NamedContextBuilder().withName("fabric8-mock-server-context")).withNewContext().withNamespace("test")).withCluster(String.format("localhost:%d", this.getPort()))).withUser("fabric8-mock-server-user")).endContext()).build();
        return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(Config.empty()).withMasterUrl(this.url("/"))).withTrustCerts(true)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2})).withNamespace("test")).withHttp2Disable(true)).addToContexts(new NamedContext[]{mockServerContext})).withCurrentContext(mockServerContext)).withUsername("fabric8-mock-server-user")).withOauthToken("secret")).build();
    }

    @Deprecated
    public NamespacedServiceCatalogClient createServiceCatalog() {
        return new DefaultServiceCatalogClient((Client)this.createClient());
    }

    @Override
    public void reset() {
        this.clearExpectations();
        this.onStart();
        this.unsupportedPatterns.clear();
        if (this.dispatcher instanceof Resetable) {
            ((Resetable)this.dispatcher).reset();
        }
    }

    @Override
    public void expectCustomResource(CustomResourceDefinitionContext rdc) {
        if (this.dispatcher instanceof CustomResourceAware) {
            ((CustomResourceAware)this.dispatcher).expectCustomResource(rdc);
        } else {
            ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.expect().get()).withPath(String.format("/apis/%s/%s", rdc.getGroup(), rdc.getVersion()))).andReturn(200, (Object)((APIResourceListBuilder)((APIResourceListBuilder)new APIResourceListBuilder().withResources(new APIResource[]{((APIResourceBuilder)((APIResourceBuilder)((APIResourceBuilder)new APIResourceBuilder().withKind(rdc.getKind())).withNamespaced(Boolean.valueOf(rdc.isNamespaceScoped()))).withName(rdc.getPlural())).build()})).withGroupVersion(ApiVersionUtil.joinApiGroupAndVersion((String)rdc.getGroup(), (String)rdc.getVersion()))).build())).once();
        }
    }
}

