/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock.crud;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.server.mock.KubernetesAttributesExtractor;
import io.fabric8.kubernetes.client.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.client.server.mock.crud.KubernetesCrudDispatcherHandler;
import io.fabric8.kubernetes.client.server.mock.crud.KubernetesCrudPersistence;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.http.MockResponse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.UUID;

public class PostHandler
implements KubernetesCrudDispatcherHandler {
    private final KubernetesAttributesExtractor attributeExtractor;
    private final KubernetesCrudPersistence persistence;

    public PostHandler(KubernetesAttributesExtractor attributeExtractor, KubernetesCrudPersistence persistence) {
        this.attributeExtractor = attributeExtractor;
        this.persistence = persistence;
    }

    @Override
    public MockResponse handle(String path, String contentType, String requestBody) throws KubernetesCrudDispatcherException {
        GenericKubernetesResource resource = this.validateRequestBody(requestBody);
        AttributeSet attributes = this.persistence.getKey(path).add(new Attribute[]{new Attribute("name", KubernetesResourceUtil.getName((HasMetadata)resource))});
        if (this.persistence.findResource(attributes) != null) {
            throw new KubernetesCrudDispatcherException(String.format("%s '%s' already exists", resource.getKind(), resource.getMetadata().getName()), 409, resource.getKind(), new String[0]);
        }
        if (resource.isMarkedForDeletion()) {
            resource.getMetadata().setDeletionTimestamp(null);
        }
        this.initMetadata((HasMetadata)resource, path);
        if (this.persistence.isStatusSubresourceEnabledForResource(path)) {
            resource.getAdditionalProperties().remove("status");
        }
        String response = Serialization.asJson((Object)resource);
        this.persistence.processEvent(path, attributes, null, resource, response);
        return new MockResponse().setResponseCode(201).setBody(response);
    }

    private void initMetadata(HasMetadata resource, String path) throws KubernetesCrudDispatcherException {
        UUID uuid = Utils.generateId();
        if (Utils.isNullOrEmpty((String)resource.getMetadata().getName())) {
            resource.getMetadata().setName(resource.getMetadata().getGenerateName() + "-" + uuid);
        }
        String pathNamespace = this.attributeExtractor.fromKubernetesPath(path).get("namespace");
        String metadataNamespace = resource.getMetadata().getNamespace();
        if (Utils.isNotNullOrEmpty((String)metadataNamespace) && !pathNamespace.equals(metadataNamespace)) {
            throw new KubernetesCrudDispatcherException("the namespace of the object (" + metadataNamespace + ") does not match the namespace on the URL (" + pathNamespace + ")", 400, resource.getKind(), new String[0]);
        }
        resource.getMetadata().setNamespace(pathNamespace);
        resource.getMetadata().setUid(uuid.toString());
        resource.getMetadata().setCreationTimestamp(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_INSTANT));
        resource.getMetadata().setResourceVersion(String.valueOf(this.persistence.requestResourceVersion()));
        resource.getMetadata().setGeneration(Long.valueOf(1L));
    }
}

