/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.MavenJDOMWriter;
import io.fabric8.maven.SortedProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;

public final class Maven {
    private Maven() {
        throw new IllegalAccessError("Utility class");
    }

    public static Model newModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setProperties((Properties)new SortedProperties());
        return model;
    }

    public static Model readModel(String path) {
        return Maven.readModel(Paths.get(path, new String[0]));
    }

    public static Model readModel(Path pom) {
        Model model;
        block8: {
            BufferedReader br = Files.newBufferedReader(pom);
            try {
                Model model2 = Maven.readModel(br);
                model2.setPomFile(pom.toFile());
                SortedProperties sortedProps = new SortedProperties();
                sortedProps.putAll((Map<?, ?>)model2.getProperties());
                model2.setProperties((Properties)sortedProps);
                model = model2;
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException("Error while reading pom.xml", io);
                }
            }
            br.close();
        }
        return model;
    }

    public static Model readModel(Reader rdr) {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read(rdr);
            SortedProperties sortedProps = new SortedProperties();
            sortedProps.putAll((Map<?, ?>)model.getProperties());
            model.setProperties((Properties)sortedProps);
            return model;
        }
        catch (IOException io) {
            throw new UncheckedIOException("Error while reading pom.xml", io);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Error while parsing pom.xml", e);
        }
    }

    public static void writeModel(Model model) {
        Maven.writeModel(model, model.getPomFile().toPath());
    }

    public static void writeModel(Model model, Path pom) {
        block31: {
            Document document;
            if (pom.toFile().length() == 0L) {
                try (OutputStream os = Files.newOutputStream(pom, new OpenOption[0]);){
                    MavenXpp3Writer writer = new MavenXpp3Writer();
                    writer.write(os, model);
                    break block31;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not write POM file: " + pom, e);
                }
            }
            try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
                document = new SAXBuilder().build(is);
            }
            catch (JDOMException e) {
                throw new RuntimeException("Could not parse POM file: " + pom, e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not read POM file: " + pom, e);
            }
            try (OutputStream os = Files.newOutputStream(pom, new OpenOption[0]);
                 OutputStreamWriter ow = new OutputStreamWriter(os);){
                MavenJDOMWriter writer = new MavenJDOMWriter();
                Format format = Format.getPrettyFormat();
                format.setLineSeparator(System.lineSeparator());
                writer.write(model, document, ow, format);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not write POM file: " + pom, e);
            }
        }
    }
}

