/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import io.fabric8.zjsonpatch.JsonPatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class CrudDispatcher
extends Dispatcher {
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String PATCH = "PATCH";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    protected Map<AttributeSet, String> map = new HashMap<AttributeSet, String>();
    protected final Context context;
    protected final AttributeExtractor attributeExtractor;
    protected final ResponseComposer responseComposer;

    public CrudDispatcher(Context context, AttributeExtractor attributeExtractor, ResponseComposer responseComposer) {
        this.context = context;
        this.attributeExtractor = attributeExtractor;
        this.responseComposer = responseComposer;
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String path = request.getPath();
        String method = request.getMethod();
        switch (method.toUpperCase()) {
            case "POST": 
            case "PUT": {
                return this.handleCreate(path, request.getBody().readUtf8());
            }
            case "PATCH": {
                return this.handlePatch(path, request.getBody().readUtf8());
            }
            case "GET": {
                return this.handleGet(path);
            }
            case "DELETE": {
                return this.handleDelete(path);
            }
        }
        return null;
    }

    public MockResponse handleCreate(String path, String s) {
        MockResponse response = new MockResponse();
        AttributeSet features = AttributeSet.merge(this.attributeExtractor.fromPath(path), this.attributeExtractor.fromResource(s));
        this.map.put(features, s);
        response.setBody(s);
        response.setResponseCode(202);
        return response;
    }

    public MockResponse handlePatch(String path, String s) {
        MockResponse response = new MockResponse();
        String body = this.doGet(path);
        if (body == null) {
            response.setResponseCode(404);
        } else {
            try {
                JsonNode patch = this.context.getMapper().readTree(s);
                JsonNode source = this.context.getMapper().readTree(body);
                JsonNode updated = JsonPatch.apply((JsonNode)patch, (JsonNode)source);
                String updatedAsString = this.context.getMapper().writeValueAsString((Object)updated);
                AttributeSet features = AttributeSet.merge(this.attributeExtractor.fromPath(path), this.attributeExtractor.fromResource(updatedAsString));
                this.map.put(features, updatedAsString);
                response.setResponseCode(202);
                response.setBody(updatedAsString);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return response;
    }

    public MockResponse handleUpdate(String path, String s) {
        return this.handleCreate(path, s);
    }

    public MockResponse handleGet(String path) {
        MockResponse response = new MockResponse();
        String body = this.doGet(path);
        if (body == null) {
            response.setResponseCode(404);
        } else {
            response.setResponseCode(200);
            response.setBody(body);
        }
        return response;
    }

    public MockResponse handleDelete(String path) {
        MockResponse response = new MockResponse();
        ArrayList<AttributeSet> items = new ArrayList<AttributeSet>();
        AttributeSet query = this.attributeExtractor.extract(path);
        for (Map.Entry<AttributeSet, String> entry : this.map.entrySet()) {
            if (!entry.getKey().matches(query)) continue;
            items.add(entry.getKey());
        }
        if (!items.isEmpty()) {
            for (AttributeSet item : items) {
                this.map.remove(item);
            }
            response.setResponseCode(200);
        } else {
            response.setResponseCode(404);
        }
        return response;
    }

    public Map<AttributeSet, String> getMap() {
        return this.map;
    }

    public AttributeExtractor getAttributeExtractor() {
        return this.attributeExtractor;
    }

    public ResponseComposer getResponseComposer() {
        return this.responseComposer;
    }

    private String doGet(String path) {
        ArrayList<String> items = new ArrayList<String>();
        AttributeSet query = this.attributeExtractor.extract(path);
        for (Map.Entry<AttributeSet, String> entry : this.map.entrySet()) {
            if (!entry.getKey().matches(query)) continue;
            items.add(entry.getValue());
        }
        if (items.isEmpty()) {
            return null;
        }
        if (items.size() == 1) {
            return (String)items.get(0);
        }
        return this.responseComposer.compose(items);
    }
}

