/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Buffer {
    private final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();

    public Buffer() {
        this(new byte[0]);
    }

    public Buffer(byte[] bytes) {
        if (bytes != null) {
            this.byteStream.write(bytes, 0, bytes.length);
        }
    }

    public final byte[] getBytes() {
        return this.byteStream.toByteArray();
    }

    public final long size() {
        return this.byteStream.size();
    }

    public final byte[] readByteArray() {
        byte[] bytes = this.getBytes();
        this.byteStream.reset();
        return bytes;
    }

    public final String readString(Charset charset) {
        return new String(this.readByteArray(), charset);
    }

    public final String readUtf8() {
        return this.readString(StandardCharsets.UTF_8);
    }

    public final Buffer write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    public Buffer write(byte[] bytes, int off, int len) {
        this.byteStream.write(bytes, off, len);
        return this;
    }

    public final Buffer writeString(String string, Charset charset) {
        return this.write(string.getBytes(charset));
    }

    public final Buffer writeUtf8(String string) {
        return this.writeString(string, StandardCharsets.UTF_8);
    }

    public final InputStream inputStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public final void flush() {
    }
}

