/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public class HttpUrl {
    private final URI uri;

    public HttpUrl(URI uri) {
        this.uri = uri;
    }

    public final URI uri() {
        return this.uri;
    }

    public final String encodedPath() {
        String path = this.uri().getRawPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        return this.uri().getRawPath();
    }

    public final String queryParameter(String name) {
        List values = (List)new QueryStringDecoder(this.uri()).parameters().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public final String toString() {
        return this.uri().toString();
    }

    public static HttpUrl fromUrl(URL url) {
        try {
            return new HttpUrl(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: " + String.valueOf(url), e);
        }
    }

    public static HttpUrl parse(String url) {
        try {
            return HttpUrl.fromUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }
}

