/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.TemplateTransformation;
import io.sundr.transform.annotations.TemplateTransformations;
import java.util.HashSet;
import java.util.Set;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.jsonschema2pojo.AbstractAnnotator;

public class ModelAnnotator
extends AbstractAnnotator {
    private static final String BUILDABLE_REFERENCE_VALUE = "value";
    private final Set<String> handledClasses = new HashSet<String>();

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        try {
            if (this.handledClasses.contains(clazz.fullName())) {
                return;
            }
            clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
            clazz.annotate(ToString.class);
            clazz.annotate(EqualsAndHashCode.class);
            clazz.annotate(Setter.class);
            clazz.annotate(Accessors.class).paramArray("prefix").param("_").param("");
            JAnnotationUse buildable = clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", false).param("generateBuilderPackage", false).param("builderPackage", "io.fabric8.kubernetes.api.builder");
            JAnnotationArrayMember refs = buildable.paramArray("refs");
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.ObjectMeta"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.ObjectReference"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.LabelSelector"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Container"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.EnvVar"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.ContainerPort"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Volume"));
            refs.annotate(BuildableReference.class).param(BUILDABLE_REFERENCE_VALUE, (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.VolumeMount"));
            if (this.isCRD(clazz, propertiesNode) || this.isCRDList(clazz, propertiesNode)) {
                String apiVersion = this.getApiVersion(propertiesNode);
                clazz.annotate(Version.class).param(BUILDABLE_REFERENCE_VALUE, this.extractVersion(apiVersion));
                clazz.annotate(Group.class).param(BUILDABLE_REFERENCE_VALUE, this.extractGroup(apiVersion));
            }
            if (this.isCRD(clazz, propertiesNode)) {
                JAnnotationArrayMember arrayMember = clazz.annotate(TemplateTransformations.class).paramArray(BUILDABLE_REFERENCE_VALUE);
                arrayMember.annotate(TemplateTransformation.class).param(BUILDABLE_REFERENCE_VALUE, "/manifest.vm").param("outputPath", "model.properties").param("gather", true);
            }
            this.handledClasses.add(clazz.fullName());
        }
        catch (JClassAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.has("javaOmitEmpty") && propertyNode.get("javaOmitEmpty").asBoolean(false)) {
            field.annotate(JsonInclude.class).param(BUILDABLE_REFERENCE_VALUE, (Enum)JsonInclude.Include.NON_EMPTY);
        }
    }

    private boolean hasApiVersionWithDefault(JsonNode propertiesNode) {
        JsonNode apiVersion = propertiesNode.get("apiVersion");
        if (apiVersion != null) {
            return apiVersion.get("default") != null;
        }
        return false;
    }

    private boolean isCRD(JDefinedClass clazz, JsonNode propertiesNode) {
        return this.hasApiVersionWithDefault(propertiesNode) && !clazz.name().endsWith("List");
    }

    private boolean isCRDList(JDefinedClass clazz, JsonNode propertiesNode) {
        return this.hasApiVersionWithDefault(propertiesNode) && clazz.name().endsWith("List");
    }

    private String extractGroup(String apiVersion) {
        return apiVersion.split("/")[0];
    }

    private String extractVersion(String apiVersion) {
        return apiVersion.split("/")[1];
    }

    private String getApiVersion(JsonNode propertiesNode) {
        return propertiesNode.get("apiVersion").get("default").textValue();
    }
}

