package io.fabric8.openshift.client;

import java.lang.SuppressWarnings;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.client.ConfigFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpenShiftConfigFluent<A extends OpenShiftConfigFluent<A>> extends ConfigFluent<A>{
  public OpenShiftConfigFluent() {
  }
  
  public OpenShiftConfigFluent(OpenShiftConfig instance) {
    this.copyInstance(instance);
  }
  private String oapiVersion;
  private String openShiftUrl;
  private Long buildTimeout;
  private Boolean disableApiGroupCheck;
  
  protected void copyInstance(OpenShiftConfig instance) {
    instance = (instance != null ? instance : new OpenShiftConfig());
    if (instance != null) {
          this.withOpenShiftUrl(instance.getOpenShiftUrl());
          this.withOapiVersion(instance.getOapiVersion());
          this.withMasterUrl(instance.getMasterUrl());
          this.withApiVersion(instance.getApiVersion());
          this.withNamespace(instance.getNamespace());
          this.withTrustCerts(instance.isTrustCerts());
          this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
          this.withCaCertFile(instance.getCaCertFile());
          this.withCaCertData(instance.getCaCertData());
          this.withClientCertFile(instance.getClientCertFile());
          this.withClientCertData(instance.getClientCertData());
          this.withClientKeyFile(instance.getClientKeyFile());
          this.withClientKeyData(instance.getClientKeyData());
          this.withClientKeyAlgo(instance.getClientKeyAlgo());
          this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
          this.withUsername(instance.getUsername());
          this.withPassword(instance.getPassword());
          this.withOauthToken(instance.getOauthToken());
          this.withAutoOAuthToken(instance.getAutoOAuthToken());
          this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
          this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
          this.withConnectionTimeout(instance.getConnectionTimeout());
          this.withRequestTimeout(instance.getRequestTimeout());
          this.withScaleTimeout(instance.getScaleTimeout());
          this.withLoggingInterval(instance.getLoggingInterval());
          this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
          this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
          this.withHttp2Disable(instance.isHttp2Disable());
          this.withHttpProxy(instance.getHttpProxy());
          this.withHttpsProxy(instance.getHttpsProxy());
          this.withNoProxy(instance.getNoProxy());
          this.withUserAgent(instance.getUserAgent());
          this.withTlsVersions(instance.getTlsVersions());
          this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
          this.withProxyUsername(instance.getProxyUsername());
          this.withProxyPassword(instance.getProxyPassword());
          this.withTrustStoreFile(instance.getTrustStoreFile());
          this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
          this.withKeyStoreFile(instance.getKeyStoreFile());
          this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
          this.withImpersonateUsername(instance.getImpersonateUsername());
          this.withImpersonateGroups(instance.getImpersonateGroups());
          this.withImpersonateExtras(instance.getImpersonateExtras());
          this.withOauthTokenProvider(instance.getOauthTokenProvider());
          this.withCustomHeaders(instance.getCustomHeaders());
          this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
          this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
          this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
          this.withOnlyHttpWatches(instance.isOnlyHttpWatches());
          this.withBuildTimeout(instance.getBuildTimeout());
          this.withDisableApiGroupCheck(instance.isDisableApiGroupCheck());
          this.withCurrentContext(instance.getCurrentContext());
          this.withContexts(instance.getContexts());
          this.withAutoConfigure(instance.getAutoConfigure());
          this.withAuthProvider(instance.getAuthProvider());
        }
  }
  
  public String getOapiVersion() {
    return this.oapiVersion;
  }
  
  public A withOapiVersion(String oapiVersion) {
    this.oapiVersion = oapiVersion;
    return (A) this;
  }
  
  public boolean hasOapiVersion() {
    return this.oapiVersion != null;
  }
  
  public String getOpenShiftUrl() {
    return this.openShiftUrl;
  }
  
  public A withOpenShiftUrl(String openShiftUrl) {
    this.openShiftUrl = openShiftUrl;
    return (A) this;
  }
  
  public boolean hasOpenShiftUrl() {
    return this.openShiftUrl != null;
  }
  
  public Long getBuildTimeout() {
    return this.buildTimeout;
  }
  
  public A withBuildTimeout(Long buildTimeout) {
    this.buildTimeout = buildTimeout;
    return (A) this;
  }
  
  public boolean hasBuildTimeout() {
    return this.buildTimeout != null;
  }
  
  public Boolean getDisableApiGroupCheck() {
    return this.disableApiGroupCheck;
  }
  
  public A withDisableApiGroupCheck(Boolean disableApiGroupCheck) {
    this.disableApiGroupCheck = disableApiGroupCheck;
    return (A) this;
  }
  
  public boolean hasDisableApiGroupCheck() {
    return this.disableApiGroupCheck != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenShiftConfigFluent that = (OpenShiftConfigFluent) o;
    if (!java.util.Objects.equals(oapiVersion, that.oapiVersion)) return false;
    if (!java.util.Objects.equals(openShiftUrl, that.openShiftUrl)) return false;
    if (!java.util.Objects.equals(buildTimeout, that.buildTimeout)) return false;
    if (!java.util.Objects.equals(disableApiGroupCheck, that.disableApiGroupCheck)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(oapiVersion,  openShiftUrl,  buildTimeout,  disableApiGroupCheck,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (oapiVersion != null) { sb.append("oapiVersion:"); sb.append(oapiVersion + ","); }
    if (openShiftUrl != null) { sb.append("openShiftUrl:"); sb.append(openShiftUrl + ","); }
    if (buildTimeout != null) { sb.append("buildTimeout:"); sb.append(buildTimeout + ","); }
    if (disableApiGroupCheck != null) { sb.append("disableApiGroupCheck:"); sb.append(disableApiGroupCheck); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDisableApiGroupCheck() {
    return withDisableApiGroupCheck(true);
  }
  

}