package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OpenShiftConfigBuilder extends io.fabric8.openshift.client.OpenShiftConfigFluentImpl<io.fabric8.openshift.client.OpenShiftConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.client.OpenShiftConfig,io.fabric8.openshift.client.OpenShiftConfigBuilder>{
  public OpenShiftConfigBuilder() {
    this(false);
  }
  public OpenShiftConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new OpenShiftConfig(), validationEnabled);
  }
  public OpenShiftConfigBuilder(io.fabric8.openshift.client.OpenShiftConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftConfigBuilder(io.fabric8.openshift.client.OpenShiftConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OpenShiftConfig(), validationEnabled);
  }
  public OpenShiftConfigBuilder(io.fabric8.openshift.client.OpenShiftConfigFluent<?> fluent,io.fabric8.openshift.client.OpenShiftConfig instance) {
    this(fluent, instance, false);
  }
  public OpenShiftConfigBuilder(io.fabric8.openshift.client.OpenShiftConfigFluent<?> fluent,io.fabric8.openshift.client.OpenShiftConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withOpenShiftUrl(instance.getOpenShiftUrl()); 
    fluent.withOapiVersion(instance.getOapiVersion()); 
    fluent.withMasterUrl(instance.getMasterUrl()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withTrustCerts(instance.isTrustCerts()); 
    fluent.withDisableHostnameVerification(instance.isDisableHostnameVerification()); 
    fluent.withCaCertFile(instance.getCaCertFile()); 
    fluent.withCaCertData(instance.getCaCertData()); 
    fluent.withClientCertFile(instance.getClientCertFile()); 
    fluent.withClientCertData(instance.getClientCertData()); 
    fluent.withClientKeyFile(instance.getClientKeyFile()); 
    fluent.withClientKeyData(instance.getClientKeyData()); 
    fluent.withClientKeyAlgo(instance.getClientKeyAlgo()); 
    fluent.withClientKeyPassphrase(instance.getClientKeyPassphrase()); 
    fluent.withUsername(instance.getUsername()); 
    fluent.withPassword(instance.getPassword()); 
    fluent.withOauthToken(instance.getOauthToken()); 
    fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval()); 
    fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit()); 
    fluent.withConnectionTimeout(instance.getConnectionTimeout()); 
    fluent.withRequestTimeout(instance.getRequestTimeout()); 
    fluent.withRollingTimeout(instance.getRollingTimeout()); 
    fluent.withScaleTimeout(instance.getScaleTimeout()); 
    fluent.withLoggingInterval(instance.getLoggingInterval()); 
    fluent.withMaxConcurrentRequests(instance.getMaxConcurrentRequests()); 
    fluent.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost()); 
    fluent.withHttp2Disable(instance.isHttp2Disable()); 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    fluent.withErrorMessages(instance.getErrorMessages()); 
    fluent.withUserAgent(instance.getUserAgent()); 
    fluent.withTlsVersions(instance.getTlsVersions()); 
    fluent.withWebsocketTimeout(instance.getWebsocketTimeout()); 
    fluent.withWebsocketPingInterval(instance.getWebsocketPingInterval()); 
    fluent.withProxyUsername(instance.getProxyUsername()); 
    fluent.withProxyPassword(instance.getProxyPassword()); 
    fluent.withTrustStoreFile(instance.getTrustStoreFile()); 
    fluent.withTrustStorePassphrase(instance.getTrustStorePassphrase()); 
    fluent.withKeyStoreFile(instance.getKeyStoreFile()); 
    fluent.withKeyStorePassphrase(instance.getKeyStorePassphrase()); 
    fluent.withImpersonateUsername(instance.getImpersonateUsername()); 
    fluent.withImpersonateGroups(instance.getImpersonateGroups()); 
    fluent.withImpersonateExtras(instance.getImpersonateExtras()); 
    fluent.withOauthTokenProvider(instance.getOauthTokenProvider()); 
    fluent.withCustomHeaders(instance.getCustomHeaders()); 
    fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit()); 
    fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval()); 
    fluent.withUploadConnectionTimeout(instance.getUploadConnectionTimeout()); 
    fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout()); 
    fluent.withBuildTimeout(instance.getBuildTimeout()); 
    fluent.withOpenshiftApiGroupsEnabled(instance.isOpenshiftApiGroupsEnabled()); 
    fluent.withDisableApiGroupCheck(instance.isDisableApiGroupCheck()); 
    fluent.withTrustCerts(instance.isTrustCerts());

    fluent.withDisableHostnameVerification(instance.isDisableHostnameVerification());

    fluent.withMasterUrl(instance.getMasterUrl());

    fluent.withApiVersion(instance.getApiVersion());

    fluent.withNamespace(instance.getNamespace());

    fluent.withCaCertFile(instance.getCaCertFile());

    fluent.withCaCertData(instance.getCaCertData());

    fluent.withClientCertFile(instance.getClientCertFile());

    fluent.withClientCertData(instance.getClientCertData());

    fluent.withClientKeyFile(instance.getClientKeyFile());

    fluent.withClientKeyData(instance.getClientKeyData());

    fluent.withClientKeyAlgo(instance.getClientKeyAlgo());

    fluent.withClientKeyPassphrase(instance.getClientKeyPassphrase());

    fluent.withTrustStoreFile(instance.getTrustStoreFile());

    fluent.withTrustStorePassphrase(instance.getTrustStorePassphrase());

    fluent.withKeyStoreFile(instance.getKeyStoreFile());

    fluent.withKeyStorePassphrase(instance.getKeyStorePassphrase());

    fluent.withAuthProvider(instance.getAuthProvider());

    fluent.withContexts(instance.getContexts());

    fluent.withCurrentContext(instance.getCurrentContext());

    fluent.withUsername(instance.getUsername());

    fluent.withPassword(instance.getPassword());

    fluent.withOauthToken(instance.getOauthToken());

    fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());

    fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());

    fluent.withConnectionTimeout(instance.getConnectionTimeout());

    fluent.withUploadConnectionTimeout(instance.getUploadConnectionTimeout());

    fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout());

    fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());

    fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());

    fluent.withRequestTimeout(instance.getRequestTimeout());

    fluent.withRollingTimeout(instance.getRollingTimeout());

    fluent.withScaleTimeout(instance.getScaleTimeout());

    fluent.withLoggingInterval(instance.getLoggingInterval());

    fluent.withWebsocketTimeout(instance.getWebsocketTimeout());

    fluent.withWebsocketPingInterval(instance.getWebsocketPingInterval());

    fluent.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());

    fluent.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());

    fluent.withImpersonateUsername(instance.getImpersonateUsername());

    fluent.withOauthTokenProvider(instance.getOauthTokenProvider());

    fluent.withImpersonateGroup(instance.getImpersonateGroup());

    fluent.withImpersonateGroups(instance.getImpersonateGroups());

    fluent.withImpersonateExtras(instance.getImpersonateExtras());

    fluent.withHttp2Disable(instance.isHttp2Disable());

    fluent.withHttpProxy(instance.getHttpProxy());

    fluent.withHttpsProxy(instance.getHttpsProxy());

    fluent.withProxyUsername(instance.getProxyUsername());

    fluent.withProxyPassword(instance.getProxyPassword());

    fluent.withNoProxy(instance.getNoProxy());

    fluent.withUserAgent(instance.getUserAgent());

    fluent.withTlsVersions(instance.getTlsVersions());

    fluent.withErrorMessages(instance.getErrorMessages());

    fluent.withCustomHeaders(instance.getCustomHeaders());

    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftConfigBuilder(io.fabric8.openshift.client.OpenShiftConfig instance) {
    this(instance,false);
  }
  public OpenShiftConfigBuilder(io.fabric8.openshift.client.OpenShiftConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withOpenShiftUrl(instance.getOpenShiftUrl()); 
    this.withOapiVersion(instance.getOapiVersion()); 
    this.withMasterUrl(instance.getMasterUrl()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withNamespace(instance.getNamespace()); 
    this.withTrustCerts(instance.isTrustCerts()); 
    this.withDisableHostnameVerification(instance.isDisableHostnameVerification()); 
    this.withCaCertFile(instance.getCaCertFile()); 
    this.withCaCertData(instance.getCaCertData()); 
    this.withClientCertFile(instance.getClientCertFile()); 
    this.withClientCertData(instance.getClientCertData()); 
    this.withClientKeyFile(instance.getClientKeyFile()); 
    this.withClientKeyData(instance.getClientKeyData()); 
    this.withClientKeyAlgo(instance.getClientKeyAlgo()); 
    this.withClientKeyPassphrase(instance.getClientKeyPassphrase()); 
    this.withUsername(instance.getUsername()); 
    this.withPassword(instance.getPassword()); 
    this.withOauthToken(instance.getOauthToken()); 
    this.withWatchReconnectInterval(instance.getWatchReconnectInterval()); 
    this.withWatchReconnectLimit(instance.getWatchReconnectLimit()); 
    this.withConnectionTimeout(instance.getConnectionTimeout()); 
    this.withRequestTimeout(instance.getRequestTimeout()); 
    this.withRollingTimeout(instance.getRollingTimeout()); 
    this.withScaleTimeout(instance.getScaleTimeout()); 
    this.withLoggingInterval(instance.getLoggingInterval()); 
    this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests()); 
    this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost()); 
    this.withHttp2Disable(instance.isHttp2Disable()); 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withErrorMessages(instance.getErrorMessages()); 
    this.withUserAgent(instance.getUserAgent()); 
    this.withTlsVersions(instance.getTlsVersions()); 
    this.withWebsocketTimeout(instance.getWebsocketTimeout()); 
    this.withWebsocketPingInterval(instance.getWebsocketPingInterval()); 
    this.withProxyUsername(instance.getProxyUsername()); 
    this.withProxyPassword(instance.getProxyPassword()); 
    this.withTrustStoreFile(instance.getTrustStoreFile()); 
    this.withTrustStorePassphrase(instance.getTrustStorePassphrase()); 
    this.withKeyStoreFile(instance.getKeyStoreFile()); 
    this.withKeyStorePassphrase(instance.getKeyStorePassphrase()); 
    this.withImpersonateUsername(instance.getImpersonateUsername()); 
    this.withImpersonateGroups(instance.getImpersonateGroups()); 
    this.withImpersonateExtras(instance.getImpersonateExtras()); 
    this.withOauthTokenProvider(instance.getOauthTokenProvider()); 
    this.withCustomHeaders(instance.getCustomHeaders()); 
    this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit()); 
    this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval()); 
    this.withUploadConnectionTimeout(instance.getUploadConnectionTimeout()); 
    this.withUploadRequestTimeout(instance.getUploadRequestTimeout()); 
    this.withBuildTimeout(instance.getBuildTimeout()); 
    this.withOpenshiftApiGroupsEnabled(instance.isOpenshiftApiGroupsEnabled()); 
    this.withDisableApiGroupCheck(instance.isDisableApiGroupCheck()); 
    this.withTrustCerts(instance.isTrustCerts());

    this.withDisableHostnameVerification(instance.isDisableHostnameVerification());

    this.withMasterUrl(instance.getMasterUrl());

    this.withApiVersion(instance.getApiVersion());

    this.withNamespace(instance.getNamespace());

    this.withCaCertFile(instance.getCaCertFile());

    this.withCaCertData(instance.getCaCertData());

    this.withClientCertFile(instance.getClientCertFile());

    this.withClientCertData(instance.getClientCertData());

    this.withClientKeyFile(instance.getClientKeyFile());

    this.withClientKeyData(instance.getClientKeyData());

    this.withClientKeyAlgo(instance.getClientKeyAlgo());

    this.withClientKeyPassphrase(instance.getClientKeyPassphrase());

    this.withTrustStoreFile(instance.getTrustStoreFile());

    this.withTrustStorePassphrase(instance.getTrustStorePassphrase());

    this.withKeyStoreFile(instance.getKeyStoreFile());

    this.withKeyStorePassphrase(instance.getKeyStorePassphrase());

    this.withAuthProvider(instance.getAuthProvider());

    this.withContexts(instance.getContexts());

    this.withCurrentContext(instance.getCurrentContext());

    this.withUsername(instance.getUsername());

    this.withPassword(instance.getPassword());

    this.withOauthToken(instance.getOauthToken());

    this.withWatchReconnectInterval(instance.getWatchReconnectInterval());

    this.withWatchReconnectLimit(instance.getWatchReconnectLimit());

    this.withConnectionTimeout(instance.getConnectionTimeout());

    this.withUploadConnectionTimeout(instance.getUploadConnectionTimeout());

    this.withUploadRequestTimeout(instance.getUploadRequestTimeout());

    this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());

    this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());

    this.withRequestTimeout(instance.getRequestTimeout());

    this.withRollingTimeout(instance.getRollingTimeout());

    this.withScaleTimeout(instance.getScaleTimeout());

    this.withLoggingInterval(instance.getLoggingInterval());

    this.withWebsocketTimeout(instance.getWebsocketTimeout());

    this.withWebsocketPingInterval(instance.getWebsocketPingInterval());

    this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());

    this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());

    this.withImpersonateUsername(instance.getImpersonateUsername());

    this.withOauthTokenProvider(instance.getOauthTokenProvider());

    this.withImpersonateGroup(instance.getImpersonateGroup());

    this.withImpersonateGroups(instance.getImpersonateGroups());

    this.withImpersonateExtras(instance.getImpersonateExtras());

    this.withHttp2Disable(instance.isHttp2Disable());

    this.withHttpProxy(instance.getHttpProxy());

    this.withHttpsProxy(instance.getHttpsProxy());

    this.withProxyUsername(instance.getProxyUsername());

    this.withProxyPassword(instance.getProxyPassword());

    this.withNoProxy(instance.getNoProxy());

    this.withUserAgent(instance.getUserAgent());

    this.withTlsVersions(instance.getTlsVersions());

    this.withErrorMessages(instance.getErrorMessages());

    this.withCustomHeaders(instance.getCustomHeaders());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.client.OpenShiftConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.client.OpenShiftConfig build() {
    OpenShiftConfig buildable = new OpenShiftConfig(fluent.getOpenShiftUrl(),fluent.getOapiVersion(),fluent.getMasterUrl(),fluent.getApiVersion(),fluent.getNamespace(),fluent.isTrustCerts(),fluent.isDisableHostnameVerification(),fluent.getCaCertFile(),fluent.getCaCertData(),fluent.getClientCertFile(),fluent.getClientCertData(),fluent.getClientKeyFile(),fluent.getClientKeyData(),fluent.getClientKeyAlgo(),fluent.getClientKeyPassphrase(),fluent.getUsername(),fluent.getPassword(),fluent.getOauthToken(),fluent.getWatchReconnectInterval(),fluent.getWatchReconnectLimit(),fluent.getConnectionTimeout(),fluent.getRequestTimeout(),fluent.getRollingTimeout(),fluent.getScaleTimeout(),fluent.getLoggingInterval(),fluent.getMaxConcurrentRequests(),fluent.getMaxConcurrentRequestsPerHost(),fluent.isHttp2Disable(),fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getErrorMessages(),fluent.getUserAgent(),fluent.getTlsVersions(),fluent.getWebsocketTimeout(),fluent.getWebsocketPingInterval(),fluent.getProxyUsername(),fluent.getProxyPassword(),fluent.getTrustStoreFile(),fluent.getTrustStorePassphrase(),fluent.getKeyStoreFile(),fluent.getKeyStorePassphrase(),fluent.getImpersonateUsername(),fluent.getImpersonateGroups(),fluent.getImpersonateExtras(),fluent.getOauthTokenProvider(),fluent.getCustomHeaders(),fluent.getRequestRetryBackoffLimit(),fluent.getRequestRetryBackoffInterval(),fluent.getUploadConnectionTimeout(),fluent.getUploadRequestTimeout(),fluent.getBuildTimeout(),fluent.isOpenshiftApiGroupsEnabled(),fluent.isDisableApiGroupCheck());
    buildable.setTrustCerts(fluent.isTrustCerts());
    buildable.setDisableHostnameVerification(fluent.isDisableHostnameVerification());
    buildable.setMasterUrl(fluent.getMasterUrl());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setNamespace(fluent.getNamespace());
    buildable.setCaCertFile(fluent.getCaCertFile());
    buildable.setCaCertData(fluent.getCaCertData());
    buildable.setClientCertFile(fluent.getClientCertFile());
    buildable.setClientCertData(fluent.getClientCertData());
    buildable.setClientKeyFile(fluent.getClientKeyFile());
    buildable.setClientKeyData(fluent.getClientKeyData());
    buildable.setClientKeyAlgo(fluent.getClientKeyAlgo());
    buildable.setClientKeyPassphrase(fluent.getClientKeyPassphrase());
    buildable.setTrustStoreFile(fluent.getTrustStoreFile());
    buildable.setTrustStorePassphrase(fluent.getTrustStorePassphrase());
    buildable.setKeyStoreFile(fluent.getKeyStoreFile());
    buildable.setKeyStorePassphrase(fluent.getKeyStorePassphrase());
    buildable.setAuthProvider(fluent.getAuthProvider());
    buildable.setContexts(fluent.getContexts());
    buildable.setCurrentContext(fluent.getCurrentContext());
    buildable.setUsername(fluent.getUsername());
    buildable.setPassword(fluent.getPassword());
    buildable.setOauthToken(fluent.getOauthToken());
    buildable.setWatchReconnectInterval(fluent.getWatchReconnectInterval());
    buildable.setWatchReconnectLimit(fluent.getWatchReconnectLimit());
    buildable.setConnectionTimeout(fluent.getConnectionTimeout());
    buildable.setUploadConnectionTimeout(fluent.getUploadConnectionTimeout());
    buildable.setUploadRequestTimeout(fluent.getUploadRequestTimeout());
    buildable.setRequestRetryBackoffLimit(fluent.getRequestRetryBackoffLimit());
    buildable.setRequestRetryBackoffInterval(fluent.getRequestRetryBackoffInterval());
    buildable.setRequestTimeout(fluent.getRequestTimeout());
    buildable.setRollingTimeout(fluent.getRollingTimeout());
    buildable.setScaleTimeout(fluent.getScaleTimeout());
    buildable.setLoggingInterval(fluent.getLoggingInterval());
    buildable.setWebsocketTimeout(fluent.getWebsocketTimeout());
    buildable.setWebsocketPingInterval(fluent.getWebsocketPingInterval());
    buildable.setMaxConcurrentRequests(fluent.getMaxConcurrentRequests());
    buildable.setMaxConcurrentRequestsPerHost(fluent.getMaxConcurrentRequestsPerHost());
    buildable.setImpersonateUsername(fluent.getImpersonateUsername());
    buildable.setOauthTokenProvider(fluent.getOauthTokenProvider());
    buildable.setImpersonateGroup(fluent.getImpersonateGroup());
    buildable.setImpersonateGroups(fluent.getImpersonateGroups());
    buildable.setImpersonateExtras(fluent.getImpersonateExtras());
    buildable.setHttp2Disable(fluent.isHttp2Disable());
    buildable.setHttpProxy(fluent.getHttpProxy());
    buildable.setHttpsProxy(fluent.getHttpsProxy());
    buildable.setProxyUsername(fluent.getProxyUsername());
    buildable.setProxyPassword(fluent.getProxyPassword());
    buildable.setNoProxy(fluent.getNoProxy());
    buildable.setUserAgent(fluent.getUserAgent());
    buildable.setTlsVersions(fluent.getTlsVersions());
    buildable.setErrorMessages(fluent.getErrorMessages());
    buildable.setCustomHeaders(fluent.getCustomHeaders());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenShiftConfigBuilder that = (OpenShiftConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}