
                                                    
  

package io.fabric8.openshift.client.dsl.internal.config;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Network;
import io.fabric8.openshift.api.model.NetworkBuilder;
import io.fabric8.openshift.api.model.NetworkList;

import java.util.Map;
import java.util.TreeMap;


public class NetworkOperationsImpl extends OpenShiftOperation<Network, NetworkList, Resource<Network>> {

  public NetworkOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public NetworkOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("networks"));
    this.type = Network.class;
    this.listType = NetworkList.class;
  }

  public NetworkOperationsImpl newInstance(OperationContext context) {
    return new NetworkOperationsImpl(context);
  }

  @Override
  public Network edit(Visitor... visitors) {
    return patch(new NetworkBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
