
                                                    
  

package io.fabric8.openshift.client.dsl.internal.config;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OperatorHub;
import io.fabric8.openshift.api.model.OperatorHubBuilder;
import io.fabric8.openshift.api.model.OperatorHubList;

import java.util.Map;
import java.util.TreeMap;


public class OperatorHubOperationsImpl extends OpenShiftOperation<OperatorHub, OperatorHubList, Resource<OperatorHub>> {

  public OperatorHubOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OperatorHubOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("operatorhubs"));
    this.type = OperatorHub.class;
    this.listType = OperatorHubList.class;
  }

  public OperatorHubOperationsImpl newInstance(OperationContext context) {
    return new OperatorHubOperationsImpl(context);
  }

  @Override
  public OperatorHub edit(Visitor... visitors) {
    return patch(new OperatorHubBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
