
                                                    
      

package io.fabric8.openshift.client.dsl.internal.image;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagList;

import java.util.Map;
import java.util.TreeMap;


public class ImageStreamTagOperationsImpl extends OpenShiftOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> {

  public ImageStreamTagOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ImageStreamTagOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("image.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("imagestreamtags"));
    this.type = ImageStreamTag.class;
    this.listType = ImageStreamTagList.class;
  }

  public ImageStreamTagOperationsImpl newInstance(OperationContext context) {
    return new ImageStreamTagOperationsImpl(context);
  }

  @Override
  public ImageStreamTag edit(Visitor... visitors) {
    return patch(new ImageStreamTagBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
