
                                                    
      

package io.fabric8.openshift.client.dsl.internal.monitoring.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.Alertmanager;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerList;

import java.util.Map;
import java.util.TreeMap;


public class AlertmanagerOperationsImpl extends OpenShiftOperation<Alertmanager, AlertmanagerList, Resource<Alertmanager>> {

  public AlertmanagerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public AlertmanagerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("alertmanagers"));
    this.type = Alertmanager.class;
    this.listType = AlertmanagerList.class;
  }

  public AlertmanagerOperationsImpl newInstance(OperationContext context) {
    return new AlertmanagerOperationsImpl(context);
  }

  @Override
  public Alertmanager edit(Visitor... visitors) {
    return patch(new AlertmanagerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
