
                                                    
  

package io.fabric8.openshift.client.dsl.internal.operator;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder;
import io.fabric8.openshift.api.model.operator.v1.ConsoleList;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleOperationsImpl extends OpenShiftOperation<Console, ConsoleList, Resource<Console>> {

  public ConsoleOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consoles"));
    this.type = Console.class;
    this.listType = ConsoleList.class;
  }

  public ConsoleOperationsImpl newInstance(OperationContext context) {
    return new ConsoleOperationsImpl(context);
  }

  @Override
  public Console edit(Visitor... visitors) {
    return patch(new ConsoleBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
