
                                                    
  

package io.fabric8.openshift.client.dsl.internal.operator;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerList;

import java.util.Map;
import java.util.TreeMap;


public class OpenShiftAPIServerOperationsImpl extends OpenShiftOperation<OpenShiftAPIServer, OpenShiftAPIServerList, Resource<OpenShiftAPIServer>> {

  public OpenShiftAPIServerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OpenShiftAPIServerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("openshiftapiservers"));
    this.type = OpenShiftAPIServer.class;
    this.listType = OpenShiftAPIServerList.class;
  }

  public OpenShiftAPIServerOperationsImpl newInstance(OperationContext context) {
    return new OpenShiftAPIServerOperationsImpl(context);
  }

  @Override
  public OpenShiftAPIServer edit(Visitor... visitors) {
    return patch(new OpenShiftAPIServerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
