
                                                    

package io.fabric8.openshift.client.handlers.config;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.config.OperatorHubOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.OperatorHub;
import io.fabric8.openshift.api.model.OperatorHubBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OperatorHubHandler implements ResourceHandler<OperatorHub, OperatorHubBuilder> {

  @Override
  public String getKind() {
    return OperatorHub.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public OperatorHub create(OkHttpClient client, Config config, String namespace, OperatorHub item, boolean dryRun) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public OperatorHub replace(OkHttpClient client, Config config, String namespace, OperatorHub item, boolean dryRun) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public OperatorHub reload(OkHttpClient client, Config config, String namespace, OperatorHub item) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OperatorHubBuilder edit(OperatorHub item) {
    return new OperatorHubBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OperatorHub item, boolean dryRun) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorHub item, Watcher<OperatorHub> watcher) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorHub item, String resourceVersion, Watcher<OperatorHub> watcher) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorHub item, ListOptions options, Watcher<OperatorHub> watcher) {
  return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OperatorHub waitUntilReady(OkHttpClient client, Config config, String namespace, OperatorHub item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OperatorHub waitUntilCondition(OkHttpClient client, Config config, String namespace, OperatorHub item, Predicate<OperatorHub> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
