
                                                    

package io.fabric8.openshift.client.handlers.network;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.network.EgressNetworkPolicyOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class EgressNetworkPolicyHandler implements ResourceHandler<EgressNetworkPolicy, EgressNetworkPolicyBuilder> {

  @Override
  public String getKind() {
    return EgressNetworkPolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.openshift.io/v1";
    }

  @Override
  public EgressNetworkPolicy create(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, boolean dryRun) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public EgressNetworkPolicy replace(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, boolean dryRun) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public EgressNetworkPolicy reload(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public EgressNetworkPolicyBuilder edit(EgressNetworkPolicy item) {
    return new EgressNetworkPolicyBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, EgressNetworkPolicy item, boolean dryRun) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, Watcher<EgressNetworkPolicy> watcher) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, String resourceVersion, Watcher<EgressNetworkPolicy> watcher) {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, ListOptions options, Watcher<EgressNetworkPolicy> watcher) {
  return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public EgressNetworkPolicy waitUntilReady(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public EgressNetworkPolicy waitUntilCondition(OkHttpClient client, Config config, String namespace, EgressNetworkPolicy item, Predicate<EgressNetworkPolicy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EgressNetworkPolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
