
                                                    

package io.fabric8.openshift.client.handlers.user;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.user.IdentityOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IdentityHandler implements ResourceHandler<Identity, IdentityBuilder> {

  @Override
  public String getKind() {
    return Identity.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "user.openshift.io/v1";
    }

  @Override
  public Identity create(OkHttpClient client, Config config, String namespace, Identity item, boolean dryRun) {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Identity replace(OkHttpClient client, Config config, String namespace, Identity item, boolean dryRun) {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Identity reload(OkHttpClient client, Config config, String namespace, Identity item) {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IdentityBuilder edit(Identity item) {
    return new IdentityBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Identity item, boolean dryRun) {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, Watcher<Identity> watcher) {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, String resourceVersion, Watcher<Identity> watcher) {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, ListOptions options, Watcher<Identity> watcher) {
  return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Identity waitUntilReady(OkHttpClient client, Config config, String namespace, Identity item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Identity waitUntilCondition(OkHttpClient client, Config config, String namespace, Identity item, Predicate<Identity> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
