package io.fabric8.openshift.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterAutoscalerSpecResourceLimitsFluent<A extends ClusterAutoscalerSpecResourceLimitsFluent<A>> extends BaseFluent<A>{
  public ClusterAutoscalerSpecResourceLimitsFluent() {
  }
  
  public ClusterAutoscalerSpecResourceLimitsFluent(ClusterAutoscalerSpecResourceLimits instance) {
    this.copyInstance(instance);
  }
  private ClusterAutoscalerSpecRLCoresBuilder cores;
  private ArrayList<ClusterAutoscalerSpecRLGpusBuilder> gpus = new ArrayList<ClusterAutoscalerSpecRLGpusBuilder>();
  private Integer maxNodesTotal;
  private ClusterAutoscalerSpecRLMemoryBuilder memory;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterAutoscalerSpecResourceLimits instance) {
    instance = (instance != null ? instance : new ClusterAutoscalerSpecResourceLimits());
    if (instance != null) {
          this.withCores(instance.getCores());
          this.withGpus(instance.getGpus());
          this.withMaxNodesTotal(instance.getMaxNodesTotal());
          this.withMemory(instance.getMemory());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ClusterAutoscalerSpecRLCores buildCores() {
    return this.cores != null ? this.cores.build() : null;
  }
  
  public A withCores(ClusterAutoscalerSpecRLCores cores) {
    this._visitables.remove("cores");
    if (cores != null) {
        this.cores = new ClusterAutoscalerSpecRLCoresBuilder(cores);
        this._visitables.get("cores").add(this.cores);
    } else {
        this.cores = null;
        this._visitables.get("cores").remove(this.cores);
    }
    return (A) this;
  }
  
  public boolean hasCores() {
    return this.cores != null;
  }
  
  public A withNewCores(Integer max,Integer min) {
    return (A)withCores(new ClusterAutoscalerSpecRLCores(max, min));
  }
  
  public CoresNested<A> withNewCores() {
    return new CoresNested(null);
  }
  
  public CoresNested<A> withNewCoresLike(ClusterAutoscalerSpecRLCores item) {
    return new CoresNested(item);
  }
  
  public CoresNested<A> editCores() {
    return withNewCoresLike(java.util.Optional.ofNullable(buildCores()).orElse(null));
  }
  
  public CoresNested<A> editOrNewCores() {
    return withNewCoresLike(java.util.Optional.ofNullable(buildCores()).orElse(new ClusterAutoscalerSpecRLCoresBuilder().build()));
  }
  
  public CoresNested<A> editOrNewCoresLike(ClusterAutoscalerSpecRLCores item) {
    return withNewCoresLike(java.util.Optional.ofNullable(buildCores()).orElse(item));
  }
  
  public A addToGpus(int index,ClusterAutoscalerSpecRLGpus item) {
    if (this.gpus == null) {this.gpus = new ArrayList<ClusterAutoscalerSpecRLGpusBuilder>();}
    ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
    if (index < 0 || index >= gpus.size()) {
        _visitables.get("gpus").add(builder);
        gpus.add(builder);
    } else {
        _visitables.get("gpus").add(builder);
        gpus.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToGpus(int index,ClusterAutoscalerSpecRLGpus item) {
    if (this.gpus == null) {this.gpus = new ArrayList<ClusterAutoscalerSpecRLGpusBuilder>();}
    ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);
    if (index < 0 || index >= gpus.size()) {
        _visitables.get("gpus").add(builder);
        gpus.add(builder);
    } else {
        _visitables.get("gpus").add(builder);
        gpus.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToGpus(io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLGpus... items) {
    if (this.gpus == null) {this.gpus = new ArrayList<ClusterAutoscalerSpecRLGpusBuilder>();}
    for (ClusterAutoscalerSpecRLGpus item : items) {ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);_visitables.get("gpus").add(builder);this.gpus.add(builder);} return (A)this;
  }
  
  public A addAllToGpus(Collection<ClusterAutoscalerSpecRLGpus> items) {
    if (this.gpus == null) {this.gpus = new ArrayList<ClusterAutoscalerSpecRLGpusBuilder>();}
    for (ClusterAutoscalerSpecRLGpus item : items) {ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);_visitables.get("gpus").add(builder);this.gpus.add(builder);} return (A)this;
  }
  
  public A removeFromGpus(io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLGpus... items) {
    if (this.gpus == null) return (A)this;
    for (ClusterAutoscalerSpecRLGpus item : items) {ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);_visitables.get("gpus").remove(builder); this.gpus.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGpus(Collection<ClusterAutoscalerSpecRLGpus> items) {
    if (this.gpus == null) return (A)this;
    for (ClusterAutoscalerSpecRLGpus item : items) {ClusterAutoscalerSpecRLGpusBuilder builder = new ClusterAutoscalerSpecRLGpusBuilder(item);_visitables.get("gpus").remove(builder); this.gpus.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
    if (gpus == null) return (A) this;
    final Iterator<ClusterAutoscalerSpecRLGpusBuilder> each = gpus.iterator();
    final List visitables = _visitables.get("gpus");
    while (each.hasNext()) {
      ClusterAutoscalerSpecRLGpusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterAutoscalerSpecRLGpus> buildGpus() {
    return this.gpus != null ? build(gpus) : null;
  }
  
  public ClusterAutoscalerSpecRLGpus buildGpus(int index) {
    return this.gpus.get(index).build();
  }
  
  public ClusterAutoscalerSpecRLGpus buildFirstGpus() {
    return this.gpus.get(0).build();
  }
  
  public ClusterAutoscalerSpecRLGpus buildLastGpus() {
    return this.gpus.get(gpus.size() - 1).build();
  }
  
  public ClusterAutoscalerSpecRLGpus buildMatchingGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
      for (ClusterAutoscalerSpecRLGpusBuilder item : gpus) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
      for (ClusterAutoscalerSpecRLGpusBuilder item : gpus) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGpus(List<ClusterAutoscalerSpecRLGpus> gpus) {
    if (this.gpus != null) {
      this._visitables.get("gpus").clear();
    }
    if (gpus != null) {
        this.gpus = new ArrayList();
        for (ClusterAutoscalerSpecRLGpus item : gpus) {
          this.addToGpus(item);
        }
    } else {
      this.gpus = null;
    }
    return (A) this;
  }
  
  public A withGpus(io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecRLGpus... gpus) {
    if (this.gpus != null) {
        this.gpus.clear();
        _visitables.remove("gpus");
    }
    if (gpus != null) {
      for (ClusterAutoscalerSpecRLGpus item : gpus) {
        this.addToGpus(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGpus() {
    return this.gpus != null && !this.gpus.isEmpty();
  }
  
  public A addNewGpus(Integer max,Integer min,String type) {
    return (A)addToGpus(new ClusterAutoscalerSpecRLGpus(max, min, type));
  }
  
  public GpusNested<A> addNewGpus() {
    return new GpusNested(-1, null);
  }
  
  public GpusNested<A> addNewGpusLike(ClusterAutoscalerSpecRLGpus item) {
    return new GpusNested(-1, item);
  }
  
  public GpusNested<A> setNewGpusLike(int index,ClusterAutoscalerSpecRLGpus item) {
    return new GpusNested(index, item);
  }
  
  public GpusNested<A> editGpus(int index) {
    if (gpus.size() <= index) throw new RuntimeException("Can't edit gpus. Index exceeds size.");
    return setNewGpusLike(index, buildGpus(index));
  }
  
  public GpusNested<A> editFirstGpus() {
    if (gpus.size() == 0) throw new RuntimeException("Can't edit first gpus. The list is empty.");
    return setNewGpusLike(0, buildGpus(0));
  }
  
  public GpusNested<A> editLastGpus() {
    int index = gpus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gpus. The list is empty.");
    return setNewGpusLike(index, buildGpus(index));
  }
  
  public GpusNested<A> editMatchingGpus(Predicate<ClusterAutoscalerSpecRLGpusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gpus.size();i++) { 
    if (predicate.test(gpus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gpus. No match found.");
    return setNewGpusLike(index, buildGpus(index));
  }
  
  public Integer getMaxNodesTotal() {
    return this.maxNodesTotal;
  }
  
  public A withMaxNodesTotal(Integer maxNodesTotal) {
    this.maxNodesTotal = maxNodesTotal;
    return (A) this;
  }
  
  public boolean hasMaxNodesTotal() {
    return this.maxNodesTotal != null;
  }
  
  public ClusterAutoscalerSpecRLMemory buildMemory() {
    return this.memory != null ? this.memory.build() : null;
  }
  
  public A withMemory(ClusterAutoscalerSpecRLMemory memory) {
    this._visitables.remove("memory");
    if (memory != null) {
        this.memory = new ClusterAutoscalerSpecRLMemoryBuilder(memory);
        this._visitables.get("memory").add(this.memory);
    } else {
        this.memory = null;
        this._visitables.get("memory").remove(this.memory);
    }
    return (A) this;
  }
  
  public boolean hasMemory() {
    return this.memory != null;
  }
  
  public A withNewMemory(Integer max,Integer min) {
    return (A)withMemory(new ClusterAutoscalerSpecRLMemory(max, min));
  }
  
  public MemoryNested<A> withNewMemory() {
    return new MemoryNested(null);
  }
  
  public MemoryNested<A> withNewMemoryLike(ClusterAutoscalerSpecRLMemory item) {
    return new MemoryNested(item);
  }
  
  public MemoryNested<A> editMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(null));
  }
  
  public MemoryNested<A> editOrNewMemory() {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(new ClusterAutoscalerSpecRLMemoryBuilder().build()));
  }
  
  public MemoryNested<A> editOrNewMemoryLike(ClusterAutoscalerSpecRLMemory item) {
    return withNewMemoryLike(java.util.Optional.ofNullable(buildMemory()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterAutoscalerSpecResourceLimitsFluent that = (ClusterAutoscalerSpecResourceLimitsFluent) o;
    if (!java.util.Objects.equals(cores, that.cores)) return false;
    if (!java.util.Objects.equals(gpus, that.gpus)) return false;
    if (!java.util.Objects.equals(maxNodesTotal, that.maxNodesTotal)) return false;
    if (!java.util.Objects.equals(memory, that.memory)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cores,  gpus,  maxNodesTotal,  memory,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cores != null) { sb.append("cores:"); sb.append(cores + ","); }
    if (gpus != null && !gpus.isEmpty()) { sb.append("gpus:"); sb.append(gpus + ","); }
    if (maxNodesTotal != null) { sb.append("maxNodesTotal:"); sb.append(maxNodesTotal + ","); }
    if (memory != null) { sb.append("memory:"); sb.append(memory + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CoresNested<N> extends ClusterAutoscalerSpecRLCoresFluent<CoresNested<N>> implements Nested<N>{
    CoresNested(ClusterAutoscalerSpecRLCores item) {
      this.builder = new ClusterAutoscalerSpecRLCoresBuilder(this, item);
    }
    ClusterAutoscalerSpecRLCoresBuilder builder;
    
    public N and() {
      return (N) ClusterAutoscalerSpecResourceLimitsFluent.this.withCores(builder.build());
    }
    
    public N endCores() {
      return and();
    }
    
  
  }
  public class GpusNested<N> extends ClusterAutoscalerSpecRLGpusFluent<GpusNested<N>> implements Nested<N>{
    GpusNested(int index,ClusterAutoscalerSpecRLGpus item) {
      this.index = index;
      this.builder = new ClusterAutoscalerSpecRLGpusBuilder(this, item);
    }
    ClusterAutoscalerSpecRLGpusBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterAutoscalerSpecResourceLimitsFluent.this.setToGpus(index,builder.build());
    }
    
    public N endGpus() {
      return and();
    }
    
  
  }
  public class MemoryNested<N> extends ClusterAutoscalerSpecRLMemoryFluent<MemoryNested<N>> implements Nested<N>{
    MemoryNested(ClusterAutoscalerSpecRLMemory item) {
      this.builder = new ClusterAutoscalerSpecRLMemoryBuilder(this, item);
    }
    ClusterAutoscalerSpecRLMemoryBuilder builder;
    
    public N and() {
      return (N) ClusterAutoscalerSpecResourceLimitsFluent.this.withMemory(builder.build());
    }
    
    public N endMemory() {
      return and();
    }
    
  
  }

}